CREATE FUNCTION code.list_notifications_by_ids(
    i_uid text,
    i_service text,
    i_start_local_id bigint,
    i_end_local_id bigint,
    i_limit integer,
    i_begin_ts timestamp with time zone default null,
    i_end_ts timestamp with time zone default null
) RETURNS SETOF xiva.notifications_list_type AS $$
DECLARE
    s_id bigint;
    begin_ts timestamp with time zone;
    end_ts timestamp with time zone;
BEGIN
    SELECT COALESCE(i_begin_ts, current_timestamp - '24 hours'::interval) INTO begin_ts;
    SELECT COALESCE(i_end_ts, current_timestamp + '1 hours'::interval) INTO end_ts;

    SELECT sid INTO s_id FROM xiva.services WHERE service_name = i_service;
    IF NOT FOUND THEN
        RAISE NOTICE 'Yet unknown service - %.', i_service;
        RETURN;
    END IF;

    RETURN QUERY SELECT uid, i_service, local_id,
        ROUND(EXTRACT(EPOCH FROM event_dt))::bigint AS event_ts,
        '{}'::text[], ttl, content, is_deleted,
        is_sticked, ROUND(EXTRACT(EPOCH FROM delayed_until_dt))::bigint
            AS delayed_until_ts, topic
      FROM xiva.notifications
      WHERE sid = s_id AND uid = i_uid
        AND event_dt >= begin_ts
        AND event_dt <= end_ts
        AND local_id >= i_start_local_id
        AND local_id <= COALESCE(i_end_local_id, 9223372036854775807)
      ORDER BY local_id
      LIMIT i_limit;
END;
$$ LANGUAGE plpgsql;
