DROP TABLE IF EXISTS xiva.broken_subscriptions;

CREATE TABLE xiva.broken_subscriptions
(
    platform text NOT NULL,
    id text NOT NULL,
    report_time timestamp with time zone NOT NULL,
    CONSTRAINT PK_BROKEN_SUBSCRIPTIONS PRIMARY KEY (platform, id),
    CONSTRAINT check_text_len CHECK (
        char_length(platform) <= 32 AND
        char_length(id) <= 128
    )
);

DROP INDEX IF EXISTS xiva.subscriptions_platform_service_id_idx;
CREATE INDEX ON xiva.subscriptions USING btree (platform, id);
