DROP VIEW IF EXISTS code.list_subscriptions;

CREATE SEQUENCE xiva.subscriptions_ack_id_seq CACHE 100000 CYCLE;

-- Very heavy on an existing database, will update every tuple
-- under exclusive lock more than once.
-- NEVER execute on a live production database.
ALTER TABLE xiva.subscriptions
    ADD COLUMN ack_id bigint UNIQUE NOT NULL
        DEFAULT nextval('xiva.subscriptions_ack_id_seq');

ALTER SEQUENCE xiva.subscriptions_ack_id_seq OWNED BY xiva.subscriptions.ack_id;

CREATE TABLE xiva.acks AS
    SELECT
        ack_id,
        ack_local_id,
        ack_time,
        smart_notify,
        next_retry_time,
        retry_interval,
        ack_event_ts
    FROM
        xiva.subscriptions;

ALTER TABLE xiva.subscriptions
    DROP COLUMN ack_local_id RESTRICT,
    DROP COLUMN ack_time RESTRICT,
    DROP COLUMN smart_notify RESTRICT,
    DROP COLUMN next_retry_time RESTRICT,
    DROP COLUMN retry_interval RESTRICT,
    DROP COLUMN ack_event_ts RESTRICT;

ALTER TABLE xiva.acks
    ADD CONSTRAINT pk_ack_id PRIMARY KEY (ack_id),
    ADD CONSTRAINT fk_ack_id FOREIGN KEY (ack_id)
        REFERENCES xiva.subscriptions(ack_id)
        ON DELETE CASCADE;
