ALTER TABLE xiva.subscriptions
    ADD COLUMN ack_local_id bigint,
    ADD COLUMN ack_time timestamptz,
    ADD COLUMN smart_notify BOOLEAN,
    ADD COLUMN next_retry_time timestamptz,
    ADD COLUMN retry_interval interval,
    ADD COLUMN ack_event_ts timestamptz;

UPDATE xiva.subscriptions
SET
    ack_local_id = acks.ack_local_id,
    ack_time = acks.ack_time,
    smart_notify = acks.smart_notify,
    next_retry_time = acks.next_retry_time,
    retry_interval = acks.retry_interval,
    ack_event_ts = acks.ack_event_ts
FROM
    xiva.acks as acks
WHERE
    xiva.subscriptions.ack_id = acks.ack_id;

DROP TABLE xiva.acks CASCADE;
DROP SEQUENCE xiva.subscriptions_ack_id_seq CASCADE;
ALTER TABLE xiva.subscriptions DROP COLUMN ack_id;
