#!/usr/bin/python3

import datetime
import psycopg2
import time
import sys

# Add shards.py location.
sys.path.append('/usr/bin/')
import shards

PREMAKE_DAYS=15

def count_remaining_partitions():
    ts = int(time.time())
    today = datetime.date.today()
    conninfos = [shards.conninfo_for_write(s) for s in shards.get('xstore')]
    for conninfo in conninfos:
        dbname = shards.dbname(conninfo)
        partitions = get_xstore_partitions(conninfo)
        num_remaining_partitions = (first_missing_date(partitions, today) - today).days
        print('db.remaining_partitions.total %s %s %s' % (num_remaining_partitions, ts, dbname))

def first_missing_date(partitions, today):
    partition_dates = [get_date(p) for p in partitions]
    missing_dates = [partition_dates[i] + days(1)
        for i in range(0, len(partition_dates) - 1)
        if partition_dates[i+1] - partition_dates[i] != days(1)]
    return next(iter([d for d in missing_dates if d >= today]),
        partition_dates[-1] + days(1))

def get_xstore_partitions(conninfo):
    sql = '''
        SELECT
            table_name
        FROM
            information_schema.tables
        WHERE
            table_schema = 'xiva' AND table_name LIKE 'notifications_p%'
        ORDER BY
            table_name
    '''
    with psycopg2.connect(conninfo) as connection:
        connection.autocommit = True
        with connection.cursor() as cursor:
            cursor.execute(sql)
            return [r[0] for r in cursor.fetchall()]

# Extract date from 'notifications_pYYYY_MM_DD'
def get_date(partition_name):
    return datetime.datetime.strptime(partition_name, 'notifications_p%Y_%m_%d').date()

def days(d):
    return datetime.timedelta(days=d)

try:
    count_remaining_partitions()
except:
    pass