function ephemeral_log {
    # Usage: ephemeral_logs foldername
    rm -rf "/var/log/$1"
    mkdir -p "/ephemeral/logs/$1"
    ln -s "/ephemeral/logs/$1" /var/log/
}

if [[ -f '/kickstart_required' ]]; then
    # write logs to ephemeral disk
    ephemeral_log yxiva-resharder

    adduser --system --disabled-password --group xiva
    service procps restart

    rm /kickstart_required
fi

chown -R -H xiva /ephemeral/logs/yxiva-resharder
chown -R -H xiva /home/xiva/.pgpass
chmod 0755 /home/xiva/.postgresql
chmod 0644 /home/xiva/.postgresql/root.crt
chmod 0600 /home/xiva/.pgpass

/usr/bin/supervisord -n -c /etc/supervisor/supervisord.conf

