#!/usr/bin/env python

import yt.wrapper as yt
import yt_tables
import sys

xtable_schema = [
    {"name": "date", "type": "string", "sort_order": "ascending"},
    {"name": "service", "type": "string"},
    {"name": "platform", "type": "string"},
    {"name": "count", "type": "int64"},
    {"name": "size", "type": "int64"},
]

xstore_schema = [
    {"name": "date", "type": "string", "sort_order": "ascending"},
    {"name": "service", "type": "string"},
    {"name": "group", "type": "string"},  # 'services', 'counters', 'notifications'
    {"name": "count", "type": "int64"},
    {"name": "size", "type": "int64"},
]

db = sys.argv[1]

schema = locals()["%s_schema" % (db,)]
yt.config.set_proxy("hahn.yt.yandex.net")
yt.create("table", yt_tables.get(db), attributes={"schema": schema})
