#!/bin/bash

DEST=$1
[[ -z $DEST ]] && { echo "usage: $0 <destdir>"; exit 1; }

mkdir -p ${DEST}

cp -v console-template.html ${DEST}/console.html

for target_file in ${DEST}/console.*; do
    echo "build $target_file"
    for i in $(seq 3); do
        for var in $(grep -o -E '\${in-.*\.[a-z]+}' "$target_file"); do
            in_file=${var:2:${#var}-3}
            echo $in_file
            [[ ! -f "$in_file" ]] && { echo "  E file ${in_file} not found"; exit 1; }
            echo -e "  + $in_file"
            sed -i -e "/${var}/r ${in_file}" "$target_file"
            sed -i -e "s/${var}//" "$target_file"
        done
    done
done