#!/bin/bash

export WWWROOT=$(mktemp -d)
set -e; trap "rm -rf $WWWROOT;" EXIT ERR

pushd .. &>/dev/null
./compose.sh "$WWWROOT"
./deploy.sh "$WWWROOT"
popd &>/dev/null

URL="http://$(hostname):8000"

sed -i 's#/\* dev-placeholder \*/#//#g' "${WWWROOT}"/js/*.js
sed -i 's#https://push.yandex-team.ru#'"$URL"'#g' "${WWWROOT}"/js/*.js
sed -i 's#https://push-sandbox.yandex.ru#'"$URL"'#g' "${WWWROOT}"/js/*.js

echo ""
echo "**********************"
echo "Starting fake server"
echo "**********************"
echo ""
echo "URL: $URL"
echo "root: $WWWROOT"
echo ""

python3 server.py