#!/usr/bin/env python3

from http.server import SimpleHTTPRequestHandler, BaseHTTPRequestHandler
from urllib.parse import urlparse, parse_qsl
from json import dumps, loads, load
import os
import socketserver
import socket
import requests
from time import time
from threading import Timer
from hashlib import md5
from binascii import hexlify
from random import randint, choice
import string

with open('list.json', 'r') as f:
  list = load(f)

with open('apps_info.json', 'r') as f:
  apps_info = load(f)

with open('subscriptions.json', 'r') as f:
  subscriptions = load(f)

builddir = os.environ['WWWROOT']
os.chdir(builddir)

def new_token():
  return ''.join(choice(string.ascii_uppercase + string.digits) for _ in range(40))

class Handler(SimpleHTTPRequestHandler):
  def parse_query(self, post = False):
    self.url = urlparse(self.path)
    self.params = dict(parse_qsl(self.url.query))
    if 'Cookie' in self.headers:
      self.cookies = dict(filter(lambda x: len(x) == 2, [x.strip().split('=') for x in self.headers['Cookie'].split(';')]))
    else:
      self.cookies = {}

    if post:
      self.body = self.rfile.read(int(self.headers['content-length']))
    else:
      self.body = ''

  def serve_json(self, data):
    resp = dumps(data)
    self.send_response(200)
    self.send_header('Content-Length', len(resp))
    self.send_header('Content-Type', 'application/json')
    self.end_headers()
    self.wfile.write(resp.encode())

  def serve_text(self, data, code = 200):
    self.send_response(code)
    self.send_header('Content-Length', len(data))
    self.send_header('Content-Type', 'text/plain')
    self.end_headers()
    self.wfile.write(data.encode())

  def redirect(self, to):
    self.send_response(302)
    self.send_header("Location", to)
    self.end_headers()

  def do_GET(self):
    self.parse_query()
    print(self.url.path)

    if self.url.path == '/':
      self.redirect('/console.html')
      return

    if self.url.path.startswith('/webui/app/info'):
      platform = self.params['platform']
      app = self.params['app']
      info = apps_info[platform][app]
      print('App info data:')
      print(info)
      self.serve_json(info)
      return

    if self.url.path.find('/v2/list') != -1:
      print('Subscriptions:')
      print(subscriptions)
      self.serve_json(subscriptions)
      return

    if self.url.path.find('/v2/') != -1:
      self.redirect(self.url.path.replace('/v2/','/v2_'))
      return

    if self.url.path.find('/v2_') != -1:
        pass

    SimpleHTTPRequestHandler.do_GET(self)

  def do_POST(self):
    self.parse_query(True)
    if self.url.path.startswith('/webui/app/update'):
      print('Update app data:')
      app_data = loads(self.body)
      print(app_data)
      self.serve_json({'result': app_data});
    if self.url.path.startswith('/webui/app/revert'):
      app_data = loads(self.body)
      print(app_data)
      self.serve_json({'result': app_data});
    elif self.url.path.startswith('/webui/service/create'):
      self.create_service()
    elif self.url.path.startswith('/webui/service/'):
      self.update_service()
    elif self.url.path.startswith('/webui/send_token') or self.url.path.startswith('/webui/listen_token'):
      self.update_token()
    elif self.url.path == '/webui/list':
      self.serve_json(list)

  def create_service(self):
    data = loads(self.body)
    data['send_tokens'] = {}
    for env in ['sandbox', 'corp', 'production']:
      token = new_token()
      data['send_tokens'][env] = {token: {'name': 'default', 'service': data['name'], 'token': token}}
    data['listen_tokens'] = {}
    for env in ['sandbox', 'corp', 'prod']:
      token = new_token()
      data['listen_tokens'][env] = {token: {'name': 'default', 'service': data['name'], 'client': data['name'], 'token': token}}
    data['apps'] = []
    self.serve_json({'result': data})

  def update_service(self):
    data = loads(self.body)
    self.serve_json({'result': data})

  def update_token(self):
    data = loads(self.body)
    if not 'token' in data:
      data['token'] = new_token()
    if not 'client' in data:
      data['client'] = data['name']

    self.serve_json({'result': data})



# https://stackoverflow.com/questions/6380057/python-binding-socket-address-already-in-use/18858817#18858817
class MyTCPServer(socketserver.ThreadingTCPServer):
  address_family = socket.AF_INET6
  def server_bind(self):
    self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    self.socket.bind(self.server_address)

PORT = 8000
httpd = MyTCPServer(('::', PORT), Handler)

print('serving at port ', PORT)
try:
  httpd.serve_forever()
except KeyboardInterrupt:
  pass

shutdown = True
httpd.server_close()
print('server stopped')
