function selectAll(el) {
    if (typeof window.getSelection != "undefined" && typeof document.createRange != "undefined") {
        var range = document.createRange();
        range.selectNodeContents(el);
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange(range);
        document.execCommand('copy');
        sel.removeAllRanges();
    } else if (typeof document.selection != "undefined" && typeof document.body.createTextRange != "undefined") {
        var textRange = document.body.createTextRange();
        textRange.moveToElementText(el);
        textRange.select();
        document.execCommand('copy');
    }
}

function hideBlock(name) {
    $(name).css('max-height', 0);
    $(name).css('overflow', 'hidden');
    $(name).css('opacity', '0');
    $('.menu-item-active').removeClass('menu-item-active');
}

function showBlock(name) {
    $(name).css('max-height', '100hv');
    $(name).css('overflow', 'auto');
    $(name).css('opacity', '1');
    $('#menu-' + name.replace('#','')).addClass('menu-item-active');
}

function updateLocation(chapterId) {
    window.location = chapterId;
    navigate();
}

function showOverview(needUpdateLocation = false) {
    hideBlock('.chapter');
    showBlock('#overview');
    if (needUpdateLocation) updateLocation("#overview");
}

function showQuickStart(needUpdateLocation = false) {
    hideBlock('.chapter');
    showBlock('#quick-start');
    if (needUpdateLocation) updateLocation("#quick-start");
}

function showReference(needUpdateLocation = false) {
    hideBlock('.chapter');
    showBlock('#api-reference');
    if (needUpdateLocation) updateLocation("#api-reference");
}

function showFAQ(needUpdateLocation = false) {
    hideBlock('.chapter');
    showBlock('#faq');
    if (needUpdateLocation) updateLocation("#faq");
}

function showAccount(needUpdateLocation = false) {
    hideBlock('.chapter');
    showBlock('#account');
    if (needUpdateLocation) updateLocation("#account");
}

function showTools(needUpdateLocation = false) {
    hideBlock('.chapter');
    showBlock('#tools');
    if (needUpdateLocation) updateLocation("#tools");
}

function start_animation() {
    $('.blink').css('opacity', 0.7)
    var timerId = setTimeout(function tick() {
        $('.blink').css('opacity', 0)
        timerId = setTimeout(start_animation, 700);
    }, 700);
}

function scrollFunction() {
    // var scroll_pos = $('#topmenu').offset().top + $('#topmenu').outerHeight() * 2;
    var scroll_pos = $(window).height() / 2;
    if (document.body.scrollTop > scroll_pos || document.documentElement.scrollTop > scroll_pos) {
        $("#gototop-btn").css("display", "block");
    } else {
        $("#gototop-btn").css("display", "none");
    }
}

function scrollToTop() {
    var scroll_pos = $('#topmenu').offset().top - 30;
    document.body.scrollTop = scroll_pos;
    document.documentElement.scrollTop = scroll_pos;
}

function navigate() {
    var part = window.location.hash;
    if (part.indexOf("#services") == 0 || part.indexOf("#account") == 0) {
        showAccount();
        var link = part.substring(8);
    } else if (part.indexOf("#quick-start") == 0) {
        var link = part.substring(12);
        showQuickStart();
    } else if (part.indexOf("#api-reference") == 0) {
        showReference();
        var link = part.substring(14);
    } else if (part.indexOf("#faq") == 0) {
        showFAQ();
    } else if (part.indexOf("#tools") == 0) {
        showTools();
    } else {
        showOverview();
    }

    if (part && $(part).attr("class") != "chapter") {
        const offset = -14;
        var newTop = $(part).offset().top + offset;
        $('html,body').animate({scrollTop: newTop}, 'fast');
    } else {
        scrollToTop();
    }
}

function pingVac() {
    fetch('/ping?vac', {
        method: 'GET',
        cache: 'no-cache',
        credentials: 'include'
    });
}

function pingVacMail() {
    fetch('/ping?vacmail', {
        method: 'GET',
        cache: 'no-cache',
        credentials: 'include'
    });
}

function format_yql_query(query) {
    // Remove trailing new lines
    return query.replace(/^\n+/, "");
}

function open_yql(query, type = '') {
    url = 'https://yql.yandex-team.ru?query=' + encodeURIComponent(format_yql_query(query))
    if (type) {
        url += '&query_type=' + encodeURIComponent(type)
    }
    window.open(url, '_blank');
}

window.onscroll = function () { scrollFunction() };

$(document).ready(function () {

    data = "";
    data += "<div class=\"corner\"></div>";
    data += "<div class=\"top\"></div>";
    data += "<div class=\"corner\"></div>";
    data += "<div class=\"left\"></div>";
    data += "<div class=\"center\"></div>";
    data += "<div class=\"left\"></div>";
    data += "<div class=\"corner\"></div>";
    data += "<div class=\"top\"></div>";
    data += "<div class=\"corner\"></div>";
    $('#grid').html(data);

    $(window).on('hashchange', navigate);

    navigate();

    $('*[class^="args-"]').each(function (i, obj) {
        var className = '.' + obj.className;
        var idName = "#" + obj.className;
        $(className).each(function () {
            $(this).html($(idName).html());
        });
    });

    $('a.in-text').each(function () {
        if ($(this).attr('href') == "#"
            || ($(this).attr('href')[0] == "#" && !$($(this).attr('href')).length)) {
            $(this).css('color', 'red');
        }
    });

    $('.code-json').each(function (i, obj) {
        var data = $(this).find('pre').html();
        try {
            JSON.parse(data);
        } catch (e) {
            $(this).css('border', '1px solid red');
        }
    });

    webui_init();

    start_animation();
});