function time_now() {
    var now = new Date();
    return ((now.getHours() < 10) ? "0" : "") + now.getHours() + ":"
        + ((now.getMinutes() < 10) ? "0" : "") + now.getMinutes() + ":"
        + ((now.getSeconds() < 10) ? "0" : "") + now.getSeconds();
}

function append_system(text) {
    $('#message_box').append('<div class=\"system_msg\">' + time_now() + " " + text + '</div>');
}

function highlight_span(classname) {
    var element_class = "." + classname;
    var elements = $("#tools_list_box").find(element_class);
    elements.css("background-color", "#fcc");
}

function reset_span(classname) {
    var element_class = "." + classname;
    var elements = $("#tools_list_box").find(element_class);
    elements.css("background-color", "");
}

function show_controls(s_id) {
    $("#tools_list_item_" + s_id).find(".subscription_control").show();
    $("#tools_list_item_" + s_id).find(".subscription_control_guard").html('think twice before press');
    $("#tools_list_item_" + s_id).find(".subscription_control_guard").css('background-color', '#fff');
    $("#tools_list_item_" + s_id).find(".subscription_control_guard").css('color', 'red');
    $("#tools_list_item_" + s_id).find(".subscription_control_guard").css('cursor', 'default');
}

function twodigits(digits) {
    return (digits > 9) ? digits : '0' + digits;
}

function uts_to_str(uts) {
    if (uts == "0") {
        return "-";
    }
    var dt = new Date(uts * 1000);
    var twoDigitMonth = twodigits(dt.getMonth() + 1);
    var twoDigitDate = twodigits(dt.getDate());
    var currentDate = dt.getFullYear() + "/" + twoDigitMonth + "/" + twoDigitDate;
    return currentDate
        + " " + twodigits(dt.getHours())
        + ":" + twodigits(dt.getMinutes())
        + ":" + twodigits(dt.getSeconds());
}

function show_tools() {
    if ($('#tools_service_value').text().length > 0 && $('#tools_env_value').text().length > 0)
        $('#tools_box').removeClass('hidden');
}

function tools_select_service(name, value) {
    $('#tools_service_value').text(name);
    $('#tools_service_value').addClass('btn');
    $('#tools_service_value').addClass('tools_selected');
    $('#tools_service_ltoken').val();
    $('#tools_service_stoken').val();
    $('#tools_service_selector').addClass('hidden');
    $('#tools_env_selector_box').removeClass('hidden');
    if ($('#tools_env_value').text().length > 0) {
        tools_select_env($('#tools_env_value').text());
    }
    show_tools();
}

function tools_unselect_service() {
    $('#tools_service_value').text('');
    $('#tools_service_value').removeClass('btn');
    $('#tools_service_value').removeClass('tools_selected');
    $('#tools_service_ltoken').val();
    $('#tools_service_stoken').val();
    $('#tools_service_selector').removeClass('hidden');
}

function tools_select_env(name) {
    $('#tools_env_value').text(name);
    $('#tools_env_value').addClass('btn');
    $('#tools_env_value').addClass('tools_selected');
    $('#tools_env_selector').addClass('hidden');
    if (name == "production") {
        $('#tools_env_value').addClass('env-alarm');
    }
    show_tools();
}

function tools_unselect_env() {
    $('#tools_env_value').text('');
    $('#tools_env_value').removeClass('btn');
    $('#tools_env_value').removeClass('tools_selected');
    $('#tools_env_selector').removeClass('hidden');
    $('#tools_env_value').removeClass('env-alarm');
}

function tools_validate_uid(str) {
    var re = new RegExp("^([a-zA-Z0-9][a-zA-Z0-9@.-]*)$");
    return re.test(str);
}

async function tools_enable_btn(btn_id) {
    await tools_sleep(1000)
    console.log("enable " + btn_id);
    $(btn_id).removeClass('btn-disabled');
}

function tools_disable_btn(btn_id) {
    console.log("disable " + btn_id);
    $(btn_id).addClass('btn-disabled');
}

function append_list_line(num, item) {

    if (!item['filter']) item['filter'] = '-';
    if (item['ttl'] && item['ttl'] == 31536000) item['ttl'] = '1 year';

    var template_html = '<div class="tools_list_item" id="tools_list_item_' + num + '">';
    template_html += '<div class="s_id cell" id="s_%s_id"><span class=attr>id</span> %s_id</div>';
    if (item['url'])
        template_html += '<div class="cell"><span class=attr>host</span> %s_url</div>';
    template_html += '<div class="inlinecell"><span class=attr>client</span> %s_client</div>';
    if (item['platform'])
        template_html += '<div class="cell"><span class=attr>platform</span> %s_platform</div>';
    if (item['app'])
        template_html += '<div class="cell"><span class=attr>app_name</span> %s_app</div>';
    template_html += '<div class="cell"><span class=attr>session</span> %s_session';
    if (item['device'])
        template_html += ' <span class=attr>device</span> %s_device</div>';
    if (item['init_time'])
        template_html += '<div class="cell"><span class=attr>init</span> %s_init_time <span class=attr>ack</span> %s_pos at %s_last_sent</div>';
    template_html += '<div class="cell"><span class=attr>ttl</span> %s_ttl</div>';
    template_html += '<div class="cell attr"><span class=attr>filter</span> %s_filter</div>';
    template_html += '<div style="text-align: right">';
    template_html += '<div class="subscription_control_guard" ondblclick="javascript:show_controls(\'' + num + '\')">';
    template_html += 'guard';
    template_html += '</div>';
    template_html += '</div>';
    template_html += '<div class="subscription_control">';
    template_html += '<a href="javascript:tools_unsubscribe(\'%s_id\', ' + num + ')" class="btn_unsubscribe">unsubscribe</a>';
    template_html += '</div>';
    template_html += '</div>';
    var item_html = template_html.replace(/%[a-z_]+/g,
        function (key) { return item[key.substring(3, key.length)] })

    $('#tools_list_box').append(item_html);
}

function tools_get_access_args() {
    var env_alias = $('#tools_env_value').text();
    var env_name = g_env_settings[env_alias]["full_name"];
    return webui_get_access_args($('#tools_service_value').text(), env_name)
}

function tools_list() {
    console.log("list click");
    console.log($('#tools_list_btn').attr('class'));
    if ($('#tools_list_btn').hasClass('btn-disabled')) return;
    console.log("list run");

    // TODO validate parameters
    var args = tools_get_access_args();
    var uid = $('#i_list_uid').val();

    // Send token in parameters because of CORS requires server support
    // OPTIONS requests - webserver doesn't.
    var list_url = args.host + "/v2/list?user=" + uid + "&service=" + args.service + "&agent=web-tools";

    tools_disable_btn('#tools_list_btn');
    var hdr = $.ajax({
        type: "GET",
        url: list_url,
        cache: false,
        async: true,
        headers: { "Authorization": "XIVA " + args.ltoken },
        success: function (answer) {
            var items = answer;
            $('#tools_list_box').empty();
            $('#tools_list_box').append('<div id="tools_list_counter"></div>');
            for (var i = 0; i < items.length; ++i) {
                append_list_line(i, items[i]);
            }
            $('#tools_list_counter').html("total: " + items.length);
            tools_enable_btn('#tools_list_btn');
        },
        error: function (obj) {
            $('#tools_list_box').empty();
            $('#tools_list_counter').html("error");
            append_system('list failed: ' + String(obj.status) + ' ' + obj.statusText);
            tools_enable_btn('#tools_list_btn');
        }
    });
}

function tools_unsubscribe(s_id, num) {
    // TODO validate parameters
    var args = tools_get_access_args();

    var uid = $('#i_list_uid').val();

    // Send token in parameters because of CORS requires server support
    // OPTIONS requests - webserver doesn't.
    var url = args.host + "/v2/unsubscribe?user=" + uid + "&service=" + args.service
        + "&subscription_id=" + encodeURIComponent(s_id) + "&agent=web-tools";

    var hdr = $.ajax({
        type: "POST",
        url: url,
        cache: false,
        async: true,
        data: {},
        headers: { "Authorization": "XIVA " + args.ltoken },
        success: function () {
            // TODO enable btn
            var s_div = $('#tools_list_item_' + num)
            s_div.css("background-color", "#efefef");
            s_div.css("color", "#ccc");
            s_div.find(".subscription_control").hide();
            s_div.find(".subscription_control_guard").hide();
        },
        error: function (obj) {
            // TODO enable btn
            append_system('unsubscribe failed: ' + String(obj.status) + ' ' + obj.statusText);
        }
    });
}

function tools_sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
