var service_dialog, error_dialog, stoken_dialog, ltoken_dialog, load_screen, services_container, service_selector, app_dialog, app_info_dialog, certfile, p8keyfile, app_apns_environment, app_apns_p8_type;
var g_services, g_envs, g_admin;
var g_platform_keys = {
    apns: ['cert', 'cert-pass', 'key_id', 'key', 'issuer_key', 'topic', 'type'],
    fcm: ['apikey'],
    wns: ['sid', 'secret'],
    hms: ['client_id', 'secret']
}

var g_env_settings = {
    "production": { "host": "https://push.yandex.ru", "full_name": "production" },
    "corp": { "host": "https://push.yandex-team.ru", "full_name": "corp" },
    "yateam": { "host": "https://push.yandex-team.ru", "full_name": "corp" },
    "sandbox": { "host": "https://push-sandbox.yandex.ru", "full_name": "sandbox" },
};

var g_webui_url = "https://push.yandex-team.ru/webui/";

var TOKEN_DISPLAY_RE = /^(.{4}).*(.{4}$)/;
var TOKEN_FORMAT = '$1...$2';
var TOKEN_DISPLAY = (token) => token.replace(TOKEN_DISPLAY_RE, TOKEN_FORMAT);
var CERT_EXPIRES_DAYS_CRIT = 7;
var CERT_EXPIRES_DAYS_WARN = 30;

function webui_init() {
    if (window.location.protocol != 'https:' && window.location.hostname != 'localhost') {
        /* dev-placeholder */ $('#webui-services-container').text('Please use secure connection');
        /* dev-placeholder */ return;
    }

    $('form input').addClass('text ui-widget-content ui-corner-all');
    $('form input[type=file]').removeClass('ui-widget-content');

    services_container = $('#webui-services-container');
    service_selector = $('#tools_service_selector');

    service_dialog = $("#service-dialog").dialog({
        autoOpen: false,
        width: 350,
        modal: true,
        close: dialog_close,
        buttons: [
            { text: 'Cancel', click: function () { service_dialog.dialog('close'); } },
            { id: 'service-dialog-create-button', text: 'Save', click: create_service, class: 'button-ok' },
            { id: 'service-dialog-edit-button', text: 'Save', click: edit_service, class: 'button-ok' }]
    });

    $('.exclusive-auth').change(function () {
        if ($('.exclusive-auth:checked').length) {
            $('.exclusive-auth:not(:checked)').prop('disabled', true);
        } else {
            $('.exclusive-auth').prop('disabled', false);
        }
    });

    [
        { check: '.is-passport-check', show: '.oauth-scopes-list' },
        { check: '.is-stream-check', show: '#stream-count-inp' }
    ].forEach(bind_visibility);

    /* TODO
      form = dialog.find( "form" ).on( "submit", function( event ) {
      event.preventDefault();
      addUser();
    });*/

    stoken_dialog = $("#stoken-dialog").dialog({
        autoOpen: false,
        width: 350,
        modal: true,
        close: dialog_close,
        buttons: [
            { text: 'Cancel', click: function () { stoken_dialog.dialog('close'); } },
            { id: 'stoken-dialog-create-button', text: 'Save', click: create_stoken, class: 'button-ok' }
        ]
    });

    ltoken_dialog = $("#ltoken-dialog").dialog({
        autoOpen: false,
        width: 350,
        modal: true,
        close: dialog_close,
        buttons: [
            { text: 'Cancel', click: function () { ltoken_dialog.dialog('close'); } },
            { id: 'ltoken-dialog-create-button', text: 'Save', click: create_ltoken, class: 'button-ok' }
        ]
    });

    app_dialog = $("#app-dialog").dialog({
        autoOpen: false,
        width: 350,
        modal: true,
        close: dialog_close,
        buttons: [
            { text: 'Cancel', click: function() { app_dialog.dialog('close'); } },
            { id: 'app-dialog-create-button', text: 'Save', click: update_app, class: 'button-ok' }
        ]
    });

    app_info_dialog = $("#app-info-dialog").dialog({
        autoOpen: false,
        width: 650,
        modal: true,
        close: dialog_close,
        buttons: { OK: function () { app_info_dialog.dialog('close'); } }
    });

    $('.app-platform-prop').hide();
    $("#app-platform-group input").checkboxradio({icon: false});
    platform_select = $('input[name="platform"]', app_dialog);
    platform_select.change(function(event) {
        use_prop = '.app-prop-' + platform_select.filter(':checked').val();
        $('.app-platform-prop').hide();
        $(use_prop).show();
    });
    apns_cert_select = $('input[name="apns-cert"]', app_dialog)
    certfile = $("#app-apns-cert");
    p8keyfile = $("#app-apns-p8-key");
    app_apns_environment = $('#app-apns-environment');
    app_apns_environment.selectmenu();
    app_apns_environment.change(function() {
        app_apns_environment.selectmenu('refresh');
    });

    app_apns_p8_type = $('#app-apns-p8-type');
    app_apns_p8_type.selectmenu();
    app_apns_p8_type.change(function() {
        app_apns_p8_type.selectmenu('refresh');
    });

    $('#load-progress-bar').progressbar({ value: false });
    load_screen = $('#load-screen').dialog({
        autoOpen: false,
        classes: { 'ui-dialog': 'ui-corner-all load-screen-dialog' },
        closeOnEscape: false,
        draggable: false,
        resizable: false,
        width: 350,
        height: 100,
        modal: true
    });

    error_dialog = $('#error-dialog').dialog({
        autoOpen: false,
        width: 350,
        modal: true,
        buttons: { OK: function () { error_dialog.dialog('close'); } }
    });

    lock_controls();
    // POST to ensure that browser sends Origin.
    fetch(g_webui_url + 'list', {
        credentials: 'include',
        method: 'POST',
        cache: 'no-cache'
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof (resp) != 'object') {
            throw resp;
        }
        if (!('error' in resp)) {
            if (!('services' in resp) || resp.services === null) {
                resp.services = {};
            }
            g_admin = resp.admin === true;
            if (g_admin) {
                $('.admin-indicator').removeClass('hidden');
                $('.admin-only').removeClass('hidden');
            } else {
                $('.admin-only').addClass('hidden');
            }
            $('#service-prefix').text(resp.prefix);
            g_envs = resp.environments;
            g_services = resp.services;
            display_services();
            if (window.location.hash) {
                hash = window.location.hash;
                window.location.hash = '';
                window.location.hash = hash;
            }
        } else if ('error' in resp && resp.error == 'unauthorized' && 'redirect' in resp) {
            window.location.href = resp.redirect + window.location.href;
        } else {
            throw ('error' in resp) ? resp.error : 'Unknown error';
        }
    }).catch(function (err) { display_error('list services', err); });
};

function random_integer(min, max) {
    var rand = min + Math.random() * (max + 1 - min);
    rand = Math.floor(rand);
    return rand;
}

function webui_get_access_args(service, env) {
    var ret = {};
    ret.service = service
    ret.host = g_env_settings[env]["host"];
    ret.ltoken = "";
    ret.stoken = "";

    var ltokens = g_services[ret.service].listen_tokens[env];
    var stokens = g_services[ret.service].send_tokens[env];
    for (var i in ltokens) {
        if (ltokens[i].revoked) continue;
        ret.ltoken = i;
        break;
    }
    for (var i in stokens) {
        if (stokens[i].revoked) continue;
        ret.stoken = i;
    }
    return ret;
}

function lock_controls() {
    load_screen.dialog('open');
}

function unlock_controls() {
    load_screen.dialog('close');
}

function dialog_close() {
    $('form', this).trigger('reset');
    $('div', this).removeClass('validation-error');
    $('input', this).change();
}

function display_services() {
    services_container.empty();

    for (let name of Object.keys(g_services).sort()) {
        g_services[name].apps = g_services[name].apps.reduce(function(map, val) { map[`${val.platform}:${val.app_name}`] = val; return map; }, {})
        insert_service(g_services[name]);
    }
    $('#create-service').button().val('Create service').click(prepare_create_service);
}

function insert_service(service) {
    if (service === undefined) {
        return;
    }
    id = `n-${service.name}`;
    container = $(`#${id}`);
    if (!container.length) {
        services_container.append(`<div id="${id}" class="service-container"></div>`);
        container = $(`#${id}`);
    }
    if (service.revoked) {
        container.addClass('revoked-service');
    } else {
        container.removeClass('revoked-service');
    }
    container.html(write_service(service))

    $('.token-copy-button', container).click(function () {
        token = $('.token-input', $(this).parent('div')).data('token');
        directCopy(token);
    });
    $('.tvm-app-id-copy-button', container).click(function (event) {
        directCopy($(event.target).data('id'));
    });

    $('.edit-service', container).click(prepare_edit_service);
    $('.revoke-service', container).click(revoke_service);
    $('.restore-service', container).click(restore_service);
    $('.add-stoken', container).prop('title', 'add new send token').click(prepare_create_stoken);
    // Nothing to edit in tokens.
    //$('.edit-stoken', cell).click(edit_stoken);
    $('.revoke-stoken', container).click(revoke_stoken);
    $('.restore-stoken', container).click(restore_stoken);
    $('.add-ltoken', container).prop('title', 'add new listen token').click(prepare_create_ltoken);
    // Nothing to edit in tokens.
    //$('.edit-ltoken', cell).click(edit_ltoken);
    $('.revoke-ltoken', container).click(revoke_ltoken);
    $('.restore-ltoken', container).click(restore_ltoken);
    $('.modify-tvm-app', container).click(modify_tvm_app);
    $('.add-app', container).click(prepare_create_app);
    $('.edit-app', container).click(prepare_edit_app);
    $('.app-info', container).click(prepare_app_info);
    $('.revert-app', container).click(revert_app);
    $('.revoke-app', container).click(revoke_app);

    $('[class*=app-expires]').tooltip();

    $('.service-copy-data', container).click(copy_service_data);

    service_selector.append(`<div class=btn onclick=tools_select_service('${service.name}','')>${service.name}</div>`);
    return id;
}

function extract(object, prop) {
    p = object[prop];
    delete object[prop];
    return p;
}

function write_props(prop) {
    var owner = prop.owner;
    var link = owner_link(prop.owner);
    if (link) owner = `<a class="in-text" href="${link}">${owner}</a>`;
    return `
    <div class="service-properties item-column">
      <div class="service-property">description: ${prop.description}</div>
      <div class="service-property">owner: ${owner}</div>
      <div class="service-property">passport: ${prop.is_passport ? 'yes' : 'no'}</div>` +
        (prop.is_passport ? `<div class="service-property">OAuth scopes: ${prop.oauth_scopes.join(', ')}</div>` : '') +
        `<div class="service-property">stream: ${(prop.is_stream ? 'yes' : 'no')}</div>` +
        (prop.is_stream ? `<div class="service-property">stream count: ${prop.stream_count}</div>` : '') +
        `<div class="service-property">auth disabled: ${(prop.auth_disabled ? 'yes' : 'no')}</div>` +
        `<div class="service-property">queued delivery by default: ${(!prop.queued_delivery_by_default ? 'no' : 'yes')}</div>` +
        `</div>`
}

function write_token(token, type, env, service) {
    return `
    <div class="token ${token.revoked ? 'revoked-token' : ''}">
      <span class="token-heading">name: ${token.name}</span>` +
        (token.revoked
            ? `<span class="restore-${type} webui-icon fas fa-undo-alt" data-name="${token.name}" title="restore token" data-env="${env}" data-service="${service}" />`
            : `<span class="token-copy-button webui-icon far fa-copy" title="copy token"/>` +
            `<span class="revoke-${type} webui-icon fas fa-trash-alt" data-name="${token.name}" title="revoke token" data-env="${env}" data-service="${service}" />` +
            `<span class="edit-${type} webui-icon fas fa-edit" data-name="${token.name}" title="edit token" data-env="${env}" data-service="${service}" />`) +
        ('client' in token ? `<div>client: ${token.client}</div>` : '') +
        `<div class="token-display">
        <span>value: </span><span class="token-input" data-token="${token.token}">${TOKEN_DISPLAY(token.token)}</span>` +
        `</div>
    </div>`;
}

function write_tokens(env, service) {
    if (!(env in service.send_tokens)) service.send_tokens[env] = {};
    if (!(env in service.listen_tokens)) service.listen_tokens[env] = {};
    return `
    <span>send tokens<i class="add-stoken webui-icon fas fa-plus" data-env="${env}" title="new send token" data-service="${service.name}" /></span>
    <div>${Object.keys(service.send_tokens[env]).length ? Object.values(service.send_tokens[env]).reduce((a, v) => a + write_token(v, 'stoken', env, service.name), '') : '<div class="empty-placeholder">no tokens</div>'}</div>
    <span>listen tokens<i class="add-ltoken webui-icon fas fa-plus" data-env="${env}" title="new listen token" data-service="${service.name}" /></span>
    <div>${Object.keys(service.listen_tokens[env]).length ? Object.values(service.listen_tokens[env]).reduce((a, v) => a + write_token(v, 'ltoken', env, service.name), '') : '<div class="empty-placeholder">no tokens</div>'}</div>
    `;
}

function write_tvm_app(app, role, env, service) {
    return `
    <div class="tvm-app ${app.suspended ? 'suspended-tvm-app' : ''}">
      <span class="tvm-app-heading tvm-app-id-input">id: ${app.id}</span>
      <span class="tvm-app-id-copy-button webui-icon far fa-copy" title="copy tvm app id" data-id="${app.id}"/>
        ${write_modify_tvm_app_icon(app, role, env, service, g_admin)}
      <div>name: ${app.name}</div>
    </div>`;
}

function write_modify_tvm_app_icon(app, role, env, service, admin) {
    if (!admin) {
        return ``;
    }
    return app.suspended
        ? `<span class="modify-tvm-app webui-icon fas fa-undo-alt" title="restore tvm app" data-action="restore" data-id="${app.id}" data-role="${role}" data-env="${env}" data-service="${service}" />`
        : `<span class="modify-tvm-app webui-icon fas fa-trash-alt" title="suspend tvm app" data-action="suspend" data-id="${app.id}" data-role="${role}" data-env="${env}" data-service="${service}" />`;
}

function write_app(app, service) {
    var has_expiration = 'expiration' in app && app.expiration != 0;
    if (has_expiration) {
        var expires = new Date(app.expiration * 1000);
        var days_remain = (expires - new Date()) / 1000 / 60 / 60 / 24;
        var expiration_status = days_remain < CERT_EXPIRES_DAYS_CRIT ? '-crit' : (days_remain < CERT_EXPIRES_DAYS_WARN ? '-warn' : '');
    }
    return `
    <div class="mobile-app ${app.revoked ? 'revoked-app' : ''}">
      <div class="platform-icon platform-${app.platform}" title="${app.platform.toUpperCase()}"/>
      <div>${app.app_name}</div>` +
      (g_admin ? `<i class="app-info webui-icon fas fa-eye" data-service="${service.name}" data-key="${app.platform}:${app.app_name}" title="show mobile app secret" />` : ``) +
      (has_expiration ? `<i class="webui-icon fas fa-calendar-${expiration_status ? 'times' : 'check'} app-expires${expiration_status}" title="expires ${expires.toLocaleString()}" />` : '') +
      `<i class="edit-app webui-icon fas fa-edit" title="edit mobile app" data-service="${service.name}" data-key="${app.platform}:${app.app_name}" />
      <i class="${app.can_revert ? "revert-app" : "disabled"} webui-icon fas fa-undo" title="revert mobile app secret" data-service="${service.name}" data-key="${app.platform}:${app.app_name}" />` +
      (app.revoked ? '' : `<i class="revoke-app webui-icon fas fa-trash-alt" title="revoke mobile app secret" data-service="${service.name}" data-key="${app.platform}:${app.app_name}" />`) +
    `</div>`;
}

function write_service_data(service, env) {
    if (!("tvm_publishers" in service)) service.tvm_publishers = {};
    if (!("tvm_subscribers" in service)) service.tvm_subscribers = {};
    if (!(env in service.tvm_publishers)) service.tvm_publishers[env] = [];
    if (!(env in service.tvm_subscribers)) service.tvm_subscribers[env] = [];

    return `
    <div class="token-list item-column">
      <span>Environment: ${env}</span>
      ${g_admin ? write_tokens(env, service) : ``}
      <span>tvm publishers</span>
      <div>
        ${service.tvm_publishers[env].length
            ? service.tvm_publishers[env].reduce((a, v) => a + write_tvm_app(v, 'tvm_publishers', env, service.name), '')
            : '<div class="empty-placeholder">no tvm apps</div>'}
      </div>
      <span>tvm subscribers</span>
      <div>
        ${service.tvm_subscribers[env].length
            ? service.tvm_subscribers[env].reduce((a, v) => a + write_tvm_app(v, 'tvm_subscribers', env, service.name), '')
            : '<div class="empty-placeholder">no tvm apps</div>'}
      </div>
    </div>`;
}

function write_service(service) {
    return `<span class="service-heading">${service.name}</span>` +
        (g_admin ? `<span class="service-copy-data webui-icon far fa-copy" title="copy service data" data-name="${service.name}"></span>` : '') +
        `<span class="edit-service webui-icon fas fa-edit" title="edit service" data-name="${service.name}" />` +
        (g_admin ? (service.revoked
            ? `<span class="restore-service webui-icon fas fa-undo-alt" title="restore service" data-name="${service.name}"/>`
            : `<i class="revoke-service webui-icon fas fa-trash-alt" title="revoke service" data-name="${service.name}"/>`) : '') +
        `<div class="service-container-internal">
      <div class="service-properties-container">${write_props(service)}</div>
      <div class="service-data">
        ${g_envs.reduce((a, v) => a + write_service_data(service, v), '')}
      </div>
      <div class="item-column mobile-apps"><span>mobile apps<i class="add-app webui-icon fas fa-plus" title="new mobile app" data-service="${service.name}" /></span>
        ${Object.keys(service.apps).length ? Object.values(service.apps).reduce((a, v) => a + write_app(v, service), '') : '<div class="empty-placeholder">no apps</div>'}
      </div>
    </div>`;
}

function prepare_create_service(event) {
    $('[name=name]', service_dialog).prop('disabled', false);
    $('#owner-field').show();
    $('#service-prefix').show();
    $('#service-name').data('validator', 'isalnum_ext_req');
    $('#service-stream-count').val(16);
    $('#service-dialog-create-button').show();
    $('#service-dialog-edit-button').hide();
    service_dialog.dialog('option', 'title', 'Create service').dialog('open');
}

function create_service() {
    if (!validate(service_dialog)) return;
    data = form_to_object(service_dialog);
    get_params = parse_owner(data.owner);
    delete data.owner;
    if (!data.is_passport) data.oauth_scopes = [];
    if (!data.is_stream) data.stream_count = 0;
    service_dialog.dialog('close');

    lock_controls();
    fetch(g_webui_url + `service/create?${$.param(get_params)}`, {
        credentials: 'include',
        method: 'POST',
        cache: 'no-cache',
        body: JSON.stringify(data)
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof (resp) != 'object') {
            throw resp;
        }
        res = 'result' in resp;
        err = 'error' in resp;
        if (res) {
            service = resp.result;
            g_services[service['name']] = service;
            window.location.hash = '#' + insert_service(service);
        }
        if (err) {
            msg = resp.error;
            throw res ? `Partial success: ${resp.error}` : resp.error;
        }
        if (!(res || err)) {
            throw 'Unknown error';
        }
    }).catch(function (err) { display_error('create service', err); });
}

function prepare_edit_service(event) {
    name = $(event.target).data('name');
    if (!g_admin)
        $('#owner-field').hide();
    $('[name=name]', service_dialog).prop('disabled', true);
    $('#service-prefix').hide();
    $('#service-name').data('validator', '');
    service = g_services[name];
    load_values(service_dialog, service)
    $('#service-dialog-create-button').hide();
    $('#service-dialog-edit-button').show();
    service_dialog.dialog('option', 'title', 'Edit service').dialog('open');
}

function edit_service() {
    if (!validate(service_dialog)) return;
    data = form_to_object(service_dialog);
    new_owner = data.owner;
    get_params = parse_owner(new_owner);
    delete data.env; delete data.owner;
    service_dialog.dialog('close');

    lock_controls();
    fetch(g_webui_url + `service/update?${$.param(get_params)}`, {
        credentials: 'include',
        method: 'POST',
        cache: 'no-cache',
        body: JSON.stringify(data)
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof (resp) != 'object') {
            throw resp;
        }
        if ('result' in resp) {
            service = g_services[data.name];
            data['owner'] = new_owner
            for (let key of Object.keys(data)) {
                service[key] = data[key];
            }
            insert_service(service);
        } else {
            throw ('error' in resp) ? resp.error : 'Unknown error';
        }
    }).catch(function (err) { display_error('edit service', err); });
}

function revoke_service(event) {
    name = $(event.target).data('name');
    service = g_services[name];
    if (service === undefined) {
        display_error('revoke service', `No service ${service_name}`);
        return;
    }
    if (confirm(`Do you want to revoke service ${name}?`)) {
        get_params = parse_owner(service.owner);
        lock_controls();
        fetch(g_webui_url + `service/revoke?${$.param(get_params)}`, {
            credentials: 'include',
            method: 'POST',
            cache: 'no-cache',
            body: JSON.stringify(service)
        }).then(function (resp) {
            unlock_controls();
            if (resp.headers.get('content-type') == 'application/json') {
                return resp.json();
            } else {
                return resp.text();
            }
        }).then(function (resp) {
            if (typeof (resp) != 'object') {
                throw resp;
            }
            if ('result' in resp) {
                service.revoked = true;
                insert_service(service);
            } else {
                throw ('error' in resp) ? resp.error : 'Unknown error';
            }
        }).catch(function (err) { display_error('revoke service', err); });
    }
}

function restore_service(event) {
    name = $(event.target).data('name');
    service = g_services[name];
    if (service === undefined) {
        display_error('restore service', `No service ${service_name}`);
        return;
    }
    if (confirm(`Do you want to restore service ${name}?`)) {
        get_params = parse_owner(service.owner);
        lock_controls();
        fetch(g_webui_url + `service/update?${$.param(get_params)}`, {
            credentials: 'include',
            method: 'POST',
            cache: 'no-cache',
            body: JSON.stringify(service)
        }).then(function (resp) {
            unlock_controls();
            if (resp.headers.get('content-type') == 'application/json') {
                return resp.json();
            } else {
                return resp.text();
            }
        }).then(function (resp) {
            if (typeof (resp) != 'object') {
                throw resp;
            }
            if ('result' in resp) {
                service.revoked = false;
                insert_service(service);
            } else {
                throw ('error' in resp) ? resp.error : 'Unknown error';
            }
        }).catch(function (err) { display_error('restore service', err); });
    }
}

function prepare_create_stoken(event) {
    env = $(event.target).data('env');
    service_name = $(event.target).data('service');
    $('[name=env]', stoken_dialog).val(env);
    $('[name=service]', stoken_dialog).val(service_name);
    $('[name=owner]', stoken_dialog).val(g_services[service_name].owner);
    $('[name=name]', stoken_dialog).prop('disabled', false);
    stoken_dialog.dialog('open');
}

function create_stoken() {
    if (!validate(stoken_dialog)) return;
    data = form_to_object(stoken_dialog);
    get_params = Object.assign(parse_owner(data.owner), { env: data.env });
    delete data.env; delete data.owner;
    stoken_dialog.dialog('close');

    lock_controls();
    fetch(g_webui_url + `send_token/update?${$.param(get_params)}`, {
        credentials: 'include',
        method: 'POST',
        cache: 'no-cache',
        body: JSON.stringify(data)
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof (resp) != 'object') {
            throw resp;
        }
        env = get_params.env;
        service_name = data.service;
        service = g_services[service_name];
        if (('result' in resp) && ('token' in resp.result)) {
            data.token = resp.result.token;
            if (!env in service.send_tokens) service.send_tokens[env] = {};
            service.send_tokens[env][data.token] = data;
            insert_service(service);
        } else {
            throw ('error' in resp) ? resp.error : 'Unknown error';
        }
    }).catch(function (err) { display_error('create send token', err); });
}

function edit_stoken(event) {
    env = $(event.target).data('env');
    service = $(event.target).data('service');
    name = $(event.target).data('name');
    console.log(`edit send token ${name} for ${service} in ${env}`);
}

function revoke_stoken(event) {
    env = $(event.target).data('env');
    service_name = $(event.target).data('service');
    name = $(event.target).data('name');
    service = g_services[service_name];
    if (service === undefined) {
        display_error('revoke send token', `No service ${service_name}`);
        return;
    }
    token = Object.values(service.send_tokens[env]).find(function (el) { return el.name == name; });
    if (token === undefined) {
        display_error('revoke send token', `No token ${name} in service ${service_name} in environment ${env}`);
        return;
    }
    if (confirm(`Do you want to revoke send token ${name} of service ${service_name} in environment ${env}?`)) {
        token_copy = Object.assign({}, token);
        token_copy.service = service_name;
        get_params = Object.assign(parse_owner(service.owner), { env: env });
        lock_controls();
        fetch(g_webui_url + `send_token/revoke?${$.param(get_params)}`, {
            credentials: 'include',
            method: 'POST',
            cache: 'no-cache',
            body: JSON.stringify(token_copy)
        }).then(function (resp) {
            unlock_controls();
            if (resp.headers.get('content-type') == 'application/json') {
                return resp.json();
            } else {
                return resp.text();
            }
        }).then(function (resp) {
            if (typeof (resp) != 'object') {
                throw resp;
            }
            if ('result' in resp) {
                token.revoked = true;
                insert_service(service);
            } else {
                throw ('error' in resp) ? resp.error : 'Unknown error';
            }
        }).catch(function (err) { display_error('revoke send token', err); });
    }
}

function restore_stoken(event) {
    env = $(event.target).data('env');
    service_name = $(event.target).data('service');
    name = $(event.target).data('name');
    service = g_services[service_name];
    if (service === undefined) {
        display_error('restore send token', `No service ${service_name}`);
        return;
    }
    token = Object.values(service.send_tokens[env]).find(function (el) { return el.name == name; });
    if (token === undefined) {
        display_error('restore send token', `No token ${name} in service ${service_name} in environment ${env}`);
        return;
    }
    if (confirm(`Do you want to restore send token ${name} of service ${service_name} in environment ${env}?`)) {
        token_copy = Object.assign({}, token);
        token_copy.service = service_name;
        get_params = Object.assign(parse_owner(service.owner), { env: env });
        lock_controls();
        fetch(g_webui_url + `send_token/update?${$.param(get_params)}`, {
            credentials: 'include',
            method: 'POST',
            cache: 'no-cache',
            body: JSON.stringify(token_copy)
        }).then(function (resp) {
            unlock_controls();
            if (resp.headers.get('content-type') == 'application/json') {
                return resp.json();
            } else {
                return resp.text();
            }
        }).then(function (resp) {
            if (typeof (resp) != 'object') {
                throw resp;
            }
            if ('result' in resp) {
                token.revoked = false;
                insert_service(service);
            } else {
                throw ('error' in resp) ? resp.error : 'Unknown error';
            }
        }).catch(function (err) { display_error('restore send token', err); });
    }
}

function prepare_create_ltoken(event) {
    env = $(event.target).data('env');
    service_name = $(event.target).data('service');
    $('[name=env]', ltoken_dialog).val(env);
    $('[name=service]', ltoken_dialog).val(service_name);
    $('[name=owner]', ltoken_dialog).val(g_services[service_name].owner);
    $('[name=name]', ltoken_dialog).prop('disabled', false);
    ltoken_dialog.dialog('open');
}

function create_ltoken(event) {
    if (!validate(ltoken_dialog)) return;
    data = form_to_object(ltoken_dialog);
    if (!data.client) data.client = data.service;
    get_params = Object.assign(parse_owner(data.owner), { env: data.env });
    delete data.env; delete data.owner;
    ltoken_dialog.dialog('close');

    lock_controls();
    fetch(g_webui_url + `listen_token/update?${$.param(get_params)}`, {
        credentials: 'include',
        method: 'POST',
        cache: 'no-cache',
        body: JSON.stringify(data)
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof (resp) != 'object') {
            throw resp;
        }
        env = get_params.env;
        service_name = data.service;
        service = g_services[service_name];
        if (('result' in resp) && ('token' in resp.result)) {
            delete data.service;
            data.token = resp.result.token;
            if (!env in service.listen_tokens) service.listen_tokens[env] = {};
            service.listen_tokens[env][data.token] = data;
            insert_service(service);
        } else {
            throw ('error' in resp) ? resp.error : 'Unknown error';
        }
    }).catch(function (err) { display_error('create listen token', err); });
}

function edit_ltoken(event) {
    env = $(event.target).data('env');
    service = $(event.target).data('service');
    name = $(event.target).data('name');
    console.log(`edit listen token ${name} for ${service} in ${env}`);
}

function revoke_ltoken(event) {
    env = $(event.target).data('env');
    service_name = $(event.target).data('service');
    name = $(event.target).data('name');
    service = g_services[service_name];
    if (service === undefined) {
        display_error('revoke listen token', `No service ${service_name} in environment ${env}`);
        return;
    }
    token = Object.values(service.listen_tokens[env]).find(function (el) { return el.name == name; });
    if (token === undefined) {
        display_error('revoke listen token', `No token ${name} in service ${service_name} in environment ${env}`);
        return;
    }
    if (confirm(`Do you want to revoke listen token ${name} of service ${service_name} in environment ${env}?`)) {
        token_copy = Object.assign({}, token);
        token_copy.service = service_name;
        get_params = Object.assign(parse_owner(service.owner), { env: env });
        lock_controls();
        fetch(g_webui_url + `listen_token/revoke?${$.param(get_params)}`, {
            credentials: 'include',
            method: 'POST',
            cache: 'no-cache',
            body: JSON.stringify(token_copy)
        }).then(function (resp) {
            unlock_controls();
            if (resp.headers.get('content-type') == 'application/json') {
                return resp.json();
            } else {
                return resp.text();
            }
        }).then(function (resp) {
            if (typeof (resp) != 'object') {
                throw resp;
            }
            if ('result' in resp) {
                token.revoked = true;
                insert_service(service);
            } else {
                throw ('error' in resp) ? resp.error : 'Unknown error';
            }
        }).catch(function (err) { display_error('revoke listen token', err); });
    }
}

function modify_tvm_app(event) {
    action = $(event.target).data('action');
    id = $(event.target).data('id');
    role = $(event.target).data('role');
    env = $(event.target).data('env');
    service_name = $(event.target).data('service');

    service = g_services[service_name];
    if (service === undefined) {
        display_error(`${action} tvm app`, `No service ${service_name} in environment ${env}`);
        return;
    }

    tvm_app = Object.values(service[role][env]).find(function (item) { return item.id == id; });
    if (tvm_app === undefined) {
        display_error(`${action} tvm app`, `No ${role} app ${id} in service ${service_name} in environment ${env}`);
        return;
    }

    if (!confirm(`Do you want to ${action} ${role} app ${id} of service ${service_name} in environment ${env}?`)) {
        return;
    }

    suspended = action == 'suspend';
    data = modify_tvm_app_data(service, role, env, id, suspended);
    params = parse_owner(service.owner);
    lock_controls();
    fetch(g_webui_url + `service/update?${$.param(params)}`, {
        credentials: 'include',
        method: 'POST',
        cache: 'no-cache',
        body: JSON.stringify(data)
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof (resp) != 'object') {
            throw resp;
        }
        if ('result' in resp) {
            tvm_app.suspended = suspended;
            insert_service(service);
        } else {
            throw ('error' in resp) ? resp.error : 'Unknown error';
        }
    }).catch(function (err) { display_error(`${action} tvm app`, err); });
}

function modify_tvm_app_data(service, role, env, id, suspended) {
    data = JSON.parse(JSON.stringify(service)); // Deep copy

    delete data.listen_tokens;
    delete data.send_tokens;
    delete data.tvm_publishers;
    delete data.tvm_subscribers;
    delete data.apps;

    data[role] = new Object();
    data[role][env] = new Array();
    data[role][env].push({id: id, suspended: suspended});

    return data;
}

function restore_ltoken(event) {
    env = $(event.target).data('env');
    service_name = $(event.target).data('service');
    name = $(event.target).data('name');
    service = g_services[service_name];
    if (service === undefined) {
        display_error('restore listen token', `No service ${service_name} in environment ${env}`);
        return;
    }
    token = Object.values(service.listen_tokens[env]).find(function (el) { return el.name == name; });
    if (token === undefined) {
        display_error('restore listen token', `No token ${name} in service ${service_name} in environment ${env}`);
        return;
    }
    if (confirm(`Do you want to restore listen token ${name} of service ${service_name} in environment ${env}?`)) {
        token_copy = Object.assign({}, token);
        token_copy.service = service_name;
        get_params = Object.assign(parse_owner(service.owner), { env: env });
        lock_controls();
        fetch(g_webui_url + `listen_token/update?${$.param(get_params)}`, {
            credentials: 'include',
            method: 'POST',
            cache: 'no-cache',
            body: JSON.stringify(token_copy)
        }).then(function (resp) {
            unlock_controls();
            if (resp.headers.get('content-type') == 'application/json') {
                return resp.json();
            } else {
                return resp.text();
            }
        }).then(function (resp) {
            if (typeof (resp) != 'object') {
                throw resp;
            }
            if ('result' in resp) {
                token.revoked = false;
                insert_service(service);
            } else {
                throw ('error' in resp) ? resp.error : 'Unknown error';
            }
        }).catch(function (err) { display_error('restore listen token', err); });
    }
}

function prepare_create_app(event) {
    service_name = $(event.target).data('service');
    $('[name=service]', app_dialog).val(service_name);
    $('[name=owner]', app_dialog).val(g_services[service_name].owner);
    $('[name=app_name]', app_dialog).prop('disabled', false);
    $('.app-platform-prop [data-validator]', app_dialog).data('skip-validation', '');
    $('.app-platform-prop input', app_dialog).prop('placeholder', '');
    platform_select.checkboxradio('enable');
    app_dialog.dialog('open');
}

function prepare_app_info(event) {
    service_name = $(event.target).data('service');
    service = g_services[service_name];
    key = $(event.target).data('key');
    app = service.apps[key];

    params = Object.assign(parse_owner(service.owner),
        {
            platform: app.platform,
            app: app.app_name
        }
    );
    fetch(g_webui_url + `app/info?${$.param(params)}`, {
        credentials: 'include',
        method: 'GET',
        cache: 'no-cache'
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof(resp) != 'object') {
            throw resp;
        }
        show_app_info(app, resp);
    }).catch(function (err) { display_error('get app info', err); });
}

function show_app_info(app, info) {
    $('#updated-at', app_info_dialog).html(write_app_info(uts_to_str(info["updated_at"] || 0)));
    $('#environment', app_info_dialog).html(write_app_info(info["environment"]));
    $('#current-secret', app_info_dialog).html(write_app_secret(info["current"]));
    $('#backup-secret', app_info_dialog).html(write_app_secret(info["backup"]));
    title = `Mobile app secrets ${app.platform.toUpperCase()}:${app.app_name}`;
    app_info_dialog.dialog('option', 'title', title).dialog('open');
}

function write_app_info(value) {
    if (value === undefined) {
        return `<div class="empty-placeholder">empty</div>`;
    }
    return `
    <span class="in-text-def app-info-content">
        ${value}
    </span>`;
}

function write_app_secret(app_info) {
    if (app_info === undefined || $.isEmptyObject(app_info)) {
        return `<div class="empty-placeholder">empty</div>`;
    }
    return `
    <table class="api-ref app-info-content">
        <tr class="api-ref-hdr">
            <td>Field</td>
            <td>Value</td>
        </tr>
        ${Object.entries(app_info).reduce((a, kv) => a + write_app_secret_field(kv[0], kv[1]), '')}
    </table>`;
}

function write_app_secret_field(key, value) {
    if (["Not Before", "Not After"].indexOf(key) >= 0) {
        value = uts_to_str(value);
    }
    return `
    <tr>
        <td width="30%">${key}</td>
        <td style="word-break: break-all;">${value}</td>
    </tr>`;
}

function prepare_edit_app(event) {
    //platform_data = { apns: [], fcm: [['apikey', 'app-apikey']], wns: [['sid', 'app-wns-id'], ['secret', 'app-wns-secret']] }

    service_name = $(event.target).data('service');
    service = g_services[service_name];
    key = $(event.target).data('key');
    app = service.apps[key];
    $('[name=service]', app_dialog).val(service_name);
    $('[name=owner]', app_dialog).val(service.owner);
    $('[name=app_name]', app_dialog).val(app.app_name).prop('disabled', true);
    // Leaving secret empty on edit keeps the old one.
    $('.app-platform-prop [data-validator]', app_dialog).data('skip-validation', 'true');
    $('.app-platform-prop input', app_dialog).prop('placeholder', 'no changes');
    // Update platform selector and platform-dependant fields.
    platform_select.checkboxradio('enable');
    platform_select.filter('#app-platform-' + app.platform).prop('checked', 'checked').change();
    platform_select.checkboxradio('disable');
    if (app.environment) {
        app_apns_environment.val(app.environment);
        app_apns_environment.change();
    }
    if (app.type) {
        app_apns_p8_type.val(app.type);
        app_apns_p8_type.change();
    }

    /*for (let k of platform_data[app.platform]) {
        if (k[0] in app) {
            $(`#${k[1]}`).val(app[k[0]])
        }
    }*/

    app_dialog.dialog('open');
}

function update_app(event)
{
    if (!validate(app_dialog)) return;
    data = form_to_object(app_dialog);
    get_params = parse_owner(data.owner);
    delete data.owner;

    lock_controls();

    apns_cert_type = apns_cert_select.filter(':checked').val()

    if (data.platform == 'apns' &&  apns_cert_type == 'p8') {
        readFileToDictKey(p8keyfile, data, 'key');
        // Don't close dialog before retrieving file.
        app_dialog.dialog('close');
    } else if (data.platform == 'apns' && apns_cert_type == 'deprecated') {
        delete data['type'];
        readFileToDictKey(certfile, data, 'cert');
        // Don't close dialog before retrieving file.
        app_dialog.dialog('close');
    } else {
        app_dialog.dialog('close');
        do_update_app(data, get_params)
    }
}

function do_update_app(data, get_params) {
    var our_keys = g_platform_keys[data.platform];
    var keys_to_delete = Object.entries(g_platform_keys)
        .filter(entry => entry[0] != data.platform)
        .reduce((arr, entry) => arr.concat(entry[1]), [])
        .filter(entry => -1 === our_keys.indexOf(entry));
    keys_to_delete.forEach(key => delete data[key]);

    fetch(g_webui_url + `app/update?${$.param(get_params)}`, {
        credentials: 'include',
        method: 'POST',
        cache: 'no-cache',
        body: JSON.stringify(data)
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof(resp) != 'object') {
            throw resp;
        }
        service_name = data.service;
        service = g_services[service_name];
        key = `${data.platform}:${data.app_name}`
        if ('result' in resp && !('error' in resp)) {
            delete data.service;
            service.apps[key] = resp.result;
            insert_service(service);
        } else {
            throw ('error' in resp) ? resp.error : 'Unknown error';
        }
    }).catch(function (err) { display_error('create or update app', err); });
}

function revert_app(event)
{
    service_name = $(event.target).data('service');
    service = g_services[service_name]
    key = $(event.target).data('key');
    data = $.extend({service: service_name}, service.apps[key])

    if (!confirm(`Do you want to revert application's secret for app ${data.app_name} with platform ${data.platform}?`)) {
        return;
    }
    get_params = parse_owner(service.owner);

    fetch(g_webui_url + `app/revert?${$.param(get_params)}`, {
        credentials: 'include',
        method: 'POST',
        cache: 'no-cache',
        body: JSON.stringify(data)
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof(resp) != 'object') {
            throw resp;
        }
        if ('result' in resp && !('error' in resp)) {
            // TODO Use Notify.js or something similar.
            if (!service.apps[key].revoked) {
                alert('Application reverted successfully');
            } else {
                service.apps[key] = resp['result'];
                insert_service(service);
            }
        } else {
            throw ('error' in resp) ? resp.error : 'Unknown error';
        }
    }).catch(function (err) { display_error('create or update app', err); });
}

function revoke_app(event) {
    service_name = $(event.target).data('service');
    service = g_services[service_name]
    key = $(event.target).data('key');
    data = $.extend({service: service_name}, service.apps[key])

    if (!confirm(`Do you want to revoke application's secret for app ${data.app_name} with platform ${data.platform}?`)) {
        return;
    }
    get_params = parse_owner(service.owner);

    fetch(g_webui_url + `app/revoke?${$.param(get_params)}`, {
        credentials: 'include',
        method: 'POST',
        cache: 'no-cache',
        body: JSON.stringify(data)
    }).then(function (resp) {
        unlock_controls();
        if (resp.headers.get('content-type') == 'application/json') {
            return resp.json();
        } else {
            return resp.text();
        }
    }).then(function (resp) {
        if (typeof(resp) != 'object') {
            throw resp;
        }
        if ('result' in resp && !('error' in resp)) {
            service.apps[key] = resp['result'];
            insert_service(service);
        } else {
            throw ('error' in resp) ? resp.error : 'Unknown error';
        }
    }).catch(function (err) { display_error('revoke app', err); });
}


function copy_service_data(event) {
    var service_name = $(event.target).data('name');
    if (!(service_name in g_services)) return;
    var service = g_services[service_name];
    var data = `${service.name}\n` +
        `Send tokens:\n${Object.entries(service.send_tokens).reduce((a, v) => a +
            `\t${v[0]}\n${Object.values(v[1]).reduce((ai, vi) => ai + (vi.revoked ? '' : `\t\t${vi.name} ${vi.token}\n`), '')}`, '')}` +
        `Listen tokens:\n${Object.entries(service.listen_tokens).reduce((a, v) => a +
            `\t${v[0]}\n${Object.values(v[1]).reduce((ai, vi) => ai + (vi.revoked ? '' : `\t\t${vi.name} ${vi.token}\n`), '')}`, '')}`;
    directCopy(data);
}

function bind_visibility(objs) {
    $(objs.check).change(function (event) {
        if ($(this).prop('checked')) {
            $(objs.show, $(this).closest('form')).show();
        } else {
            $(objs.show, $(this).closest('form')).hide();
        }
    });
    $(objs.check).change();
}

function load_values(dial, obj) {
    for (let key of Object.keys(obj)) {
        elem = $(`[name=${key}]`, dial);
        if (elem.length) {
            if (typeof (obj[key]) == 'boolean') {
                elem.prop('checked', obj[key]).change();
            } else if (Array.isArray(obj[key])) {
                elem.val(obj[key].join(', ')).change();
            } else {
                elem.val(obj[key]).change();
            }
        }
    }
}

function put(dest, path, val) {
    path = path.split('.');
    name = path.pop();
    for (let part of path) {
        if (!(part in dest)) {
            dest[part] = {};
        }
        dest = dest[part];
    }
    dest[name] = val;
}

function form_to_object(dial) {
    var data = {};
    $('input, select', dial).each(function () {
        name = $(this).prop('name');
        if ($(this).hasClass('multi')) {
            put(data, name, $(this).val().split(',').map(v => v.trim()).filter(v => v));
        } else if ($(this).prop('type') == 'checkbox') {
            put(data, name, $(this).prop('checked'));
        } else if ($(this).prop('type') == 'radio') {
            if ($(this).prop('checked')) {
                put(data, name, $(this).val());
            }
        } else if ($(this).prop('type') == 'number') {
            put(data, name, Number($(this).val()));
        } else {
            put(data, name, $(this).val());
        }
    });
    return data;
}

validators = {
    isalnum_ext: function (s) { return (s.length <= 50) && Boolean(s.match('^([a-zA-Z][a-zA-Z0-9-]*)?$')); },
    owner: function (s) { return (s.length <= 50) && Boolean(s.match('^(([a-z]+_)?[0-9]*|abc:[a-zA-Z][a-zA-Z0-9-_]*)?$')); },
    isalnum_ext_full: function (s) { return (s.length <= 50) && Boolean(s.match('^([a-zA-Z][a-zA-Z0-9.\\-_]*)?$')); },
    isalnum_ext_req: function (s) { return (s.length <= 50) && Boolean(s.match('^[a-zA-Z][a-zA-Z0-9-]*$')); },
    isalnum_ext_app: function (s) { return (s.length <= 50) && Boolean(s.match('^[a-zA-Z][_a-zA-Z0-9-\.]*$')); },
    scope_validator: function (s) { return Boolean(s.match('^[\x21\x23-\x5B\\x5D-\x7E ]*$')); },
    positive_number: function (n) {
        if (!$.isNumeric(n)) return false;
        n = Number(n);
        return Number.isInteger(n) && n > 0;
    },
    description: function(s) { return s.length <= 140; },
    apikey: function(s) { return s.length > 0 && s.length <= 2048; },
    has_file: function(f) { return f.length > 0; },
    any_selected: function(cont) { return $('input[type=radio]', cont).filter(':checked').length > 0 }
};

function display_error(action, message) {
    unlock_controls();
    if (message.responseJSON && 'error' in message.responseJSON) message = message.responseJSON['error'];
    else if (message.statusText) message = message.statusText;
    //if (message.responseText) message = message.responseText;
    $('#error-action').text(action);
    $('#error-message').text(message);
    error_dialog.dialog('open');
}

function parse_owner(owner) {
    if (owner.includes(':')) {
        scheme_length = owner.indexOf(':');
        return {owner_type: owner.substr(0, scheme_length), owner: owner.substr(scheme_length + 1)};
    }
    return {owner: owner.substr(owner.indexOf('_') + 1)};
}

function owner_link(owner) {
    parsed = parse_owner(owner);
    if ('owner_type' in parsed && parsed.owner_type == 'abc') {
        return 'https://abc.yandex-team.ru/services/' + parsed.owner;
    }
    return null;
}

function validate(dilaog) {
    valid = true;
    $('div', dilaog).removeClass('validation-error');
    $('[data-validator]:visible', dilaog).each(function () {
        el = $(this);
        if (el.data('skip-validation') == 'true') return;
        v = el.data('validator');
        if (v !== undefined && (v in validators)) {
            if (!validators[v](el.is('input') ? el.val() : el)) {
                valid = false;
                el.closest('div').addClass('validation-error');
            }
        }
    });
    return valid;
}

function readFileToDictKey(input, dict, key) {
    reader = new FileReader();
    reader.addEventListener('loadend', function() {
        if (reader.readyState == FileReader.DONE) {
            dict[key] = btoa(reader.result)
            do_update_app(data, get_params)
        } else {
            display_error('read file', 'unknown error')
        }
    });
    reader.addEventListener("error", function() {
        display_error('read file', reader.error.message)
    });
    reader.readAsBinaryString(input.prop('files')[0])
}

function directCopy(str) {
    //based on https://stackoverflow.com/a/12693636
    var tmp = document.oncopy
    document.oncopy = function (event) {
        event.clipboardData.setData("Text", str);
        event.preventDefault();
    };
    document.execCommand("Copy");
    document.oncopy = tmp;
}