#!/usr/bin/env python3
import re
import requests
import subprocess
import xml.etree.ElementTree as ET


def get_sharpei_url(config='/etc/equalizer/config.yml'):
    process = subprocess.Popen(['/usr/bin/config-dumper', config],
                               stdout=subprocess.PIPE,
                               bufsize=1,
                               universal_newlines=True)
    try:
        stdout, stderr = process.communicate(timeout=5)
    except:
        process.kill()
        process.wait()
        raise
    config_dump = stdout.split('\n')
    config = ET.fromstringlist(config_dump)
    sharpei_host = config.find('modules//configuration/pg/sharpei_host')

    return 'http://{}'.format(sharpei_host.text) if sharpei_host is not None else None


def get_acquired_db_list(hosts):
    acquired_dbs = dict()
    for host in hosts:
        url = 'http://{}:31080/state'.format(host)
        try:
            r = requests.get(url, timeout=3)
            for name, description in r.json().items():
                # у эква id шардов пишутся в виде: xdb{id}
                acquired_dbs[name[3:]] = host
        except:
            print('can not get data from host: {}'.format(host))
    return acquired_dbs


def get_hosts():
    r = requests.get('http://localhost:1/metadata?state=current&format=fqdn')
    r.raise_for_status()
    return r.text.strip().split(',')
