#!/usr/bin/env python3

import requests
import subprocess
import time
import xml.etree.ElementTree as ET


def get_timestamp():
    ts = int(time.time())
    return ts


def get_sharpei_dbs(sharpei_host):
    url = 'http://{}/v3/stat'.format(sharpei_host)
    db_ids = []
    r = requests.get(url, timeout=5)
    for item in r.json().items():
        db_ids.append('{}'.format(item[0]))
    return db_ids


def get_known_dbs(config='/etc/equalizer/config.yml'):
    process = subprocess.Popen(['/usr/bin/config-dumper', config],
                               stdout=subprocess.PIPE,
                               bufsize=1,
                               universal_newlines=1)
    try:
        stdout, stderr = process.communicate(timeout=5)
    except:
        process.kill()
        process.wait()
        raise
    retcode = process.poll()
    config_dump = stdout.split('\n')
    config = ET.fromstringlist(config_dump)
    sharpei_host = config.find('modules//configuration/pg/sharpei_host')
    dbs = [] if sharpei_host is None else get_sharpei_dbs(sharpei_host.text)

    db_list = config.find('modules//configuration/db_list')
    if db_list is not None:
        dbs.append(db_list.text)

    sum_known = 0
    count_known = 0
    for db in dbs:
        sum_known += int(db)
        count_known += 1

    return sum_known, count_known


def get_acquired_dbs():
    url = 'http://localhost:31080/state'

    r = requests.get(url, timeout=5)
    acquired_dbs = [item[0][3:] for item in r.json().items()]
    sum_acquired = sum([int(db) for db in acquired_dbs])

    return sum_acquired


def main():
    try:
        known_dbs_sum, known_dbs_count = get_known_dbs()
        acquired_dbs_sum = get_acquired_dbs()

        timestamp = get_timestamp()

        print("dbs.known.sum_max {} {}".format(known_dbs_sum, timestamp))
        print("dbs.known.count_max {} {}".format(known_dbs_count, timestamp))
        print("dbs.acquired.sum {} {}".format(acquired_dbs_sum, timestamp))
    except:
        pass


if __name__ == '__main__':
    main()
