#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

logfile="/var/log/$QLOUD_APPLICATION/$QLOUD_APPLICATION.log"

ts=$(date +%s)

timetail -n 60 -t imap "$logfile" | head -n -1 | \
    awk -v ts="$ts" '

    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    function dbname_from_selector(selector) {
        # [xdb123-selector]
        return substr(selector, 2, length(selector) - length("-selector]") - 1)
    }

    BEGIN {
        selector_regex="\\[([a-zA-Z0-9]+)-selector\\]"
    }

    /ymod_pq request [a-zA-Z_]+ finished in/ {
        # C5X6000SduQ1_xdb36
        split($4, splitted, "_")
        dbname=splitted[2]
        request=$9
        timing=$12/1000.0
        collect_timings(timing, "db.timings."request".tier_"dbname, metrics)
    }

    /operation: / {
        dbname=substr($6, 4); gsub("\"", "", dbname);
        action=substr($12, 8); gsub("\"", "", action);
        metrics["db.operations.total.tier_"dbname]++
        metrics["db.operations."action".total.tier_"dbname]++
    }

    /operation processed: / {
        # lag_xdb123=0.002
        split($NF, splitted, "=")
        dbname=substr(splitted[1], 5)
        lag=splitted[2]
        metrics["db.lag.tier_"dbname]=lag

        # duration=100.500
        split($(NF-1), splitted, "=")
        timing=splitted[2]
        collect_timings(timing, "db.timings.total.tier_"dbname, metrics)

        # select_output=1.234 wmi_output=5.678
        for (i=7; i <= NF-2; i++) {
            split($i, splitted, "=")
            stage=splitted[1]
            timing=splitted[2]
            collect_timings(timing, "db.timings."stage".tier_"dbname, metrics)
        }
    }

    match($0, selector_regex" sequence broken, retry needed") {
        dbname=dbname_from_selector($5)
        metrics["db.selector_retries.tier_"dbname]++
    }

    match($0, selector_regex" broken operation_id sequence:") {
        dbname=dbname_from_selector($5)
        metrics["db.broken_sequences.tier_"dbname]++
    }

    /\/batch_push?/ {
        match($0, "events_in_batch=[0-9]+")
        events_in_batch=substr($0, RSTART+16, RLENGTH-16)
        collect_values(events_in_batch, "http.events_in_batch", metrics)
    }

    END {
        values_to_hg("http.events_in_batch", metrics)
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'
