#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

logfile="/var/log/$QLOUD_APPLICATION/typed.log"

ts=$(date +%s)

timetail -n 60 -r '^tskv\ttskv_format=xiva-equalizer-log\ttimestamp=(\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d)' "$logfile" | head -n -1 | \
    awk -F $'\t|=' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    {
        dbname=$9
        uid=$11
        status=$15
        event=$17
        metrics["db.operations."event"."status".tier_"dbname]++
        if (event == "insert" && status == "dropped_queue_overflow") {
            overflowed_uids[uid]++
        }
    }

    END {
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
        print "db.users.insert_overflow_count", length(overflowed_uids), ts
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'
