#pragma once

#include <map>
#include <string>
#include <ostream>

namespace yxiva { namespace equalizer {

enum action_t
{
    UNKNOWN = 0,
    NEW_MAIL,
    MOVE_MAILS,
    MOVE_MAILS2,
    DELETE_MAILS,
    COPY_MAILS,
    MARK_MAILS,
    UNMARK_MAILS,
    CHANGE_STATUS,
    USER_UPDATE,
    RESET_FRESH,
    TRANSFER,

    TRACE_PIPELINE, // fake notification generated by selector for tracing db lag

    COUNT
};

static const char* action_to_str[action_t::COUNT] = {
    "unknown",        // UNKNOWN
    "store",          // NEW_MAIL
    "move",           // MOVE_MAILS
    "move2",          // MOVE_MAILS2
    "delete",         // DELETE_MAILS
    "copy",           // COPY_MAILS
    "mark",           // MARK_MAILS
    "unmark",         // UNMARK_MAILS
    "status",         // CHANGE_STATUS
    "user",           // USER_UPDATE
    "reset",          // RESET_FRESH
    "transfer",       // TRANSFER
    "trace_pipeline", // TRACE_PIPELINE
};

inline std::ostream& operator<<(std::ostream& o, const action_t& action)
{
    return o << action_to_str[action];
}

}}
