#pragma once

#include <atomic>
#include <boost/shared_ptr.hpp>

#include <yplatform/task_context.h>
#include <ymod_webserver/context.h>
#include <yxiva/core/types.h>

namespace yxiva { namespace equalizer {

typedef ymod_webserver::prof_accumulator prof_accumulator;

class context : public yplatform::task_context
{
public:
    context()
        : yplatform::task_context()
        , profiler_(boost::make_shared<prof_accumulator>(uniq_id()))
        , retries_(0)
    {
    }

    context(const string& ctx_uniq_id)
        : yplatform::task_context(ctx_uniq_id)
        , profiler_(boost::make_shared<prof_accumulator>(uniq_id()))
        , retries_(0)
    {
    }

    ~context()
    {
        profiler_->pop();
    }

    virtual const string& get_name() const
    {
        static const string name = "equalizer_context";
        return name;
    }

    prof_accumulator& profiler()
    {
        return *profiler_;
    }

    void increment_retries_counter()
    {
        retries_++;
    }

    void reset_retries_counter()
    {
        retries_ = 0;
    }

    unsigned int retries_count() const
    {
        return retries_;
    }

private:
    boost::shared_ptr<prof_accumulator> profiler_;
    std::atomic_uint retries_;
};

typedef boost::shared_ptr<context> context_ptr;

}}
