#pragma once

#include <mutex>

#include <yplatform/module.h>

namespace yxiva { namespace equalizer {

class module_stats : public yplatform::module_stats
{
public:
    void processed(const string& shard, std::time_t operation_ts)
    {
        scoped_lock guard(mutex_);
        auto istat = processed_ts_by_shard_.find(shard);
        if (istat != processed_ts_by_shard_.end() && istat->second <= operation_ts)
        {
            istat->second = operation_ts;
        }
    }

    void init_stats(const string& shard)
    {
        scoped_lock guard(mutex_);
        processed_ts_by_shard_[shard] = std::time(0);
    }

    void drop_stats(const string& shard)
    {
        scoped_lock guard(mutex_);
        processed_ts_by_shard_.erase(shard);
    }

    void update_db_alias_dict(const std::map<string, string>& aliases)
    {
        scoped_lock guard(mutex_);
        shard_alias_dict_ = aliases;
    }

protected:
    ptree_ptr core_get_stat() const
    {
        ptree_ptr result = yplatform::module_stats::core_get_stat();

        {
            scoped_lock guard(mutex_);
            for (auto& acc : processed_ts_by_shard_)
            {
                auto lag = std::time(0) - acc.second;
                yplatform::ptree node;
                node.put("id", acc.first);
                node.put("name", shard_alias_dict_[acc.first]);
                node.put("lag", std::to_string(lag));
                result->add_child("shard", node);
            }
        }

        return result;
    }

private:
    mutable mutex mutex_;
    mutable std::map<string, std::time_t> processed_ts_by_shard_;
    mutable std::map<string, long> lag_by_shard_;
    mutable std::map<string, string> shard_alias_dict_;
};

typedef boost::shared_ptr<module_stats> module_stats_ptr;

}}