#pragma once

#include <vector>

#include <yxiva/core/json.h>
#include <yxiva/core/user_info.h>

#include <equalizer/context.h>
#include <equalizer/action.h>

namespace yxiva { namespace equalizer {

typedef size_t id_t;

struct operation
{
    id_t stream_id;
    id_t operation_id;

    user_info ui;
    string lcn;
    action_t action_type;
    size_t total_count;
    time_t ts;
    string x_request_id;

    context_ptr ctx;
    std::vector<json_value> parts;
    json_value args;

    json_value status;

    size_t attempt;

    operation(const string& ctx_uniq_id = "")
        : stream_id(0)
        , operation_id(0)
        , action_type(action_t::UNKNOWN)
        , total_count(0)
        , ts(std::time(0))
        , ctx(new context(ctx_uniq_id))
        , attempt(0)
    {
    }

    const string uid() const
    {
        return static_cast<string>(ui.uid);
    }
    const string suid() const
    {
        return static_cast<string>(ui.suid);
    }
    const string& mdb() const
    {
        return ui.mdb;
    }

    const string& context_id() const
    {
        return ctx->uniq_id();
    }

    long long lag() const
    {
        return static_cast<long long>(std::time(0) - ts);
    }
};

typedef std::shared_ptr<operation> operation_ptr;

}}
