#pragma once

#include <map>
#include <ostream>
#include <boost/shared_ptr.hpp>
#include <boost/function.hpp>
#include <yxiva/core/json.h>

#include <ymod_webserver/request.h>
#include <ymod_webserver/response.h>
#include <yxiva/core/iabstract.h>

#include <equalizer/action.h>
#include <equalizer/operation.h>
#include <equalizer/equalizer_result.h>

namespace yxiva { namespace equalizer {

using boost::shared_ptr;

typedef boost::function<void(const boost::system::error_code&, operation_state st)> equalizer_cb_t;

class processor : iabstract
{
public:
    virtual void start_generator() = 0;
    virtual void stop_generator() = 0;
    virtual void drop_shard(const string& name, const string& alias = "") = 0;
    virtual void manualy_put_operation(
        const string& sequence_id,
        const operation& op,
        equalizer_cb_t callback) = 0;
    virtual json_value full_state() = 0;
};

typedef shared_ptr<processor> processor_ptr;

}}
