#pragma once

#include <yplatform/ptree.h>
#include <processor/equalizer.h>
#include <processor/uid_fetcher.h>
#include <postprocessor/position/syncer_settings.h>
#include <generator/selector_settings.h>
#include <generator/pg_conninfo_provider.h>

namespace yxiva { namespace equalizer {

using std::map;

typedef map<string, string> mapper_t;

struct settings
{
    bool use_selector;
    std::set<string> db_list;
    std::set<string> ignore_db_list;
    time_duration read_only_interval = seconds(15);

    StreamSettings stream;
    uid_fetcher::settings auth;
    yhttp::call::settings http;

    pg_conninfo_provider::settings pg_conn;
    selector_settings selector;
    syncer_settings<std::size_t> syncer;

    equalizer_settings eq;
    string aggregator;
};

settings load_equalizer_settings(const yplatform::ptree& xml);

}}
