#pragma once

#include <vector>

#include <yplatform/future/future.hpp>

#include <equalizer/context.h>

namespace yxiva { namespace equalizer {

template <class Operation>
class idb_select_adaptor : public std::enable_shared_from_this<idb_select_adaptor<Operation>>
{
public:
    typedef std::shared_ptr<idb_select_adaptor> ptr;
    typedef std::vector<Operation> operations_list_t;
    typedef std::shared_ptr<operations_list_t> operations_list_ptr;
    typedef yplatform::future::future<std::size_t> position_future_t;
    typedef yplatform::future::promise<std::size_t> position_promise_t;
    typedef yplatform::future::future<operations_list_ptr> operations_future_t;
    typedef yplatform::future::promise<operations_list_ptr> operations_promise_t;

    virtual position_future_t select_start_position(
        std::size_t max_offset_minutes,
        const string& db_name,
        context_ptr ctx) = 0;
    virtual operations_future_t select_operations(
        std::size_t start_id,
        std::size_t select_size,
        const string& db_name,
        context_ptr ctx) = 0;
    virtual uint64_t current_db_lag(const string& db_name) const = 0;

    virtual ~idb_select_adaptor(){};
};

}}
