#pragma once

#include <equalizer/action.h>
#include <yxiva/core/json.h>
#include <yxiva/core/types.h>

namespace yxiva { namespace equalizer {

inline action_t resolve_action_type(const string& raw_action_type, const json_value& args)
{
    if (raw_action_type == "store") return action_t::NEW_MAIL;

    if (raw_action_type == "move" || raw_action_type == "move-to-tab") return action_t::MOVE_MAILS;

    if (raw_action_type == "delete") return action_t::DELETE_MAILS;

    if (raw_action_type == "copy") return action_t::COPY_MAILS;

    if (raw_action_type == "fresh-reset") return action_t::RESET_FRESH;

    if (raw_action_type == "transfer")
    {
        return action_t::TRANSFER;
    }

    if (raw_action_type == "update")
    {
        if (!is_null(args, "seen") || !is_null(args, "recent") || !is_null(args, "deleted"))
        {
            return action_t::CHANGE_STATUS;
        }
        if (!args["lids_add"].empty())
        {
            return action_t::MARK_MAILS;
        }
        if (!args["lids_del"].empty())
        {
            return action_t::UNMARK_MAILS;
        }
    }

    return action_t::UNKNOWN;
}

}}