#pragma once

#include <ymod_pq/response_handler.h>

namespace yxiva { namespace equalizer {

class position_handler : public ymod_pq::response_handler
{
    enum columns
    {
        MAX_OPERATION_ID = 0,

        COLUMN_COUNT
    };

public:
    position_handler(yplatform::task_context_ptr ctx) : ctx_(ctx), max_operation_id_(0)
    {
    }

    virtual ~position_handler()
    {
    }

    void handle_cell(unsigned /*row*/, unsigned col, const string& val, bool is_null)
    {
        if (col >= COLUMN_COUNT)
        {
            YLOG_G(warning) << "unmapped column #" << col << " value=\"" << val << "\"";
            return;
        }

        string value = is_null ? "" : val;
        try
        {
            fill_positions(col, value);
        }
        catch (const boost::bad_lexical_cast& ex)
        {
            YLOG_CTX_GLOBAL(ctx_, error) << "[position_handler] bad cast error: col=" << col
                                         << " exception=\"" << ex.what() << "\"";
        }
    }

    void fill_positions(unsigned col, string& value)
    {
        switch (col)
        {
        case MAX_OPERATION_ID:
            max_operation_id_ = boost::lexical_cast<std::size_t>(value);
            break;
        default:
            break;
        }
    }

    unsigned column_count() const
    {
        return COLUMN_COUNT;
    }
    void handle_row_begin(unsigned /*row*/)
    {
    }
    void handle_row_end(unsigned /*row*/)
    {
    }

    std::size_t max_operation_id() const
    {
        return max_operation_id_;
    }

private:
    yplatform::task_context_ptr ctx_;
    std::size_t max_operation_id_;
};

}}