#pragma once

#include <yplatform/log.h>
#include <postprocessor/position/position_holder.h>

#include <equalizer/module_stats.h>
#include "selector.h"
#include "pg_select_adaptor.h"

namespace yxiva { namespace equalizer {

class selector_factory
{
public:
    typedef position_holder<std::size_t> position_holder_t;
    typedef std::shared_ptr<position_holder_t> position_holder_ptr;

private:
    selector_factory()
    {
    }
    selector_factory(const selector_factory&)
    {
    }
    const selector_factory& operator=(const selector_factory&) const
    {
        return *this;
    }

public:
    static void init(position_holder_ptr position_holder, conninfo_provider_ptr conninfo_provider)
    {
        instance().position_holder_ = position_holder;
        instance().conninfo_provider_ = conninfo_provider;
    }

    static void fini()
    {
        instance().position_holder_.reset();
        instance().conninfo_provider_.reset();
    }

    static std::shared_ptr<selector> create_pg_selector(
        boost::asio::io_service& io,
        selector_settings st,
        const string& mdb,
        const yplatform::log::source& logger)
    {
        assert(instance().position_holder_);
        return std::make_shared<selector>(
            io,
            st,
            mdb,
            instance().position_holder_->position(mdb),
            instance().pg_adaptor(),
            logger);
    }

private:
    static selector_factory& instance()
    {
        static selector_factory factory;
        return factory;
    }

    std::shared_ptr<pg_select_adaptor> pg_adaptor()
    {
        assert(conninfo_provider_);
        return std::make_shared<pg_select_adaptor>(conninfo_provider_);
    }

private:
    conninfo_provider_ptr conninfo_provider_;
    position_holder_ptr position_holder_;
};

}}
