#pragma once

#include <pipeline/progressive_retrier.h>
#include <yxiva/core/types.h>

namespace yxiva { namespace equalizer {

struct selector_settings
{
    std::size_t select_min_size = 0;
    std::size_t select_max_size = 0;
    /**
     * max_offset_minutes is used to retrieve more accurate start selection position (when
     * correct_start_position is true): if equalizer was too slow and restarted, it will start
     * selecting only operations appeared during last max_offset_minutes minuntes.
     */
    std::size_t max_offset_minutes = 0;
    bool correct_start_position = true;
    bool enable_trace_notification = true;

    pipeline::ProgressiveRetrier::intervals_t retry_intervals = {};
};

}}
