#pragma once

#include <yplatform/module.h>
#include <yplatform/reactor/io_pool.h>
#include <ymod_messenger/ymod_messenger.h>

#include <util/read_ptree_to_collection.h>
#include "lock_manager.h"

namespace yxiva { namespace equalizer {

class lock_manager_module : public lock_manager
{
    typedef lock_manager base_t;

public:
    void init(const yplatform::ptree& conf)
    {
        base_t::logger(yplatform::module::logger());
        load_settings(conf);
        base_t::init(global_io(), settings_.st);
        if (netch_) netch_->connect_to_cluster(settings_.acceptors);
    }

    void start()
    {
        netch_ = yplatform::find<ymod_messenger::module>("netch");
        netch_->connect_to_cluster(settings_.acceptors);
    }

    void fini()
    {
        base_t::fini();
    }

private:
    boost::asio::io_service* global_io() const
    {
        return yplatform::global_net_reactor->io();
    }

    void load_settings(const yplatform::ptree& conf)
    {
        settings_.st.max_owned_locks_count = conf.get("max_owned_locks", 1024U);
        settings_.st.extra_acquire_count = conf.get("extra_acquire_count", 10U);
        settings_.acceptors = load_cluster_settings(conf);
    }

    static std::set<string> load_cluster_settings(const yplatform::ptree& conf)
    {
        auto cluster = conf.get_child("cluster");
        std::vector<string> hosts, ports;
        read_ptree(hosts, cluster, "hosts");
        read_ptree(ports, cluster, "ports");
        // hosts * ports
        std::set<string> peers;
        for (auto host_it = hosts.begin(); host_it != hosts.end(); host_it++)
        {
            for (auto port_it = ports.begin(); port_it != ports.end(); port_it++)
            {
                peers.insert(*host_it + ":" + *port_it);
            }
        }
        return peers;
    }

private:
    struct
    {
        lock_manager_settings st;
        std::set<string> acceptors;
    } settings_;
    boost::shared_ptr<ymod_messenger::module> netch_;
};

}}
