#pragma once

#include <equalizer/operation.h>

namespace yxiva { namespace equalizer {

class equalizer_log
{
public:
    virtual void operation_sent(const string& db, const operation_ptr& op) = 0;
    virtual void operation_ignored(
        const string& db,
        const operation_ptr& op,
        const string& reason) = 0;
    virtual void operation_dropped(
        const string& db,
        const operation_ptr& op,
        const string& reason) = 0;

    virtual ~equalizer_log()
    {
    }
};

typedef std::shared_ptr<equalizer_log> equalizer_log_ptr;

class log_db_wrapper
{
public:
    log_db_wrapper(const string& db, equalizer_log_ptr logger) : db_(db), logger_(logger)
    {
    }

    inline void operation_sent(const operation_ptr& op) const
    {
        logger_->operation_sent(db_, op);
    }

    inline void operation_ignored(const operation_ptr& op, const string& reason) const
    {
        logger_->operation_ignored(db_, op, reason);
    }

    inline void operation_dropped(const operation_ptr& op, const string& reason) const
    {
        logger_->operation_dropped(db_, op, reason);
    }

private:
    const string db_;
    const equalizer_log_ptr logger_;
};

}}