#pragma once

#include <boost/optional.hpp>
#include <yplatform/module.h>
#include <yplatform/log/typed.h>

#include <equalizer/operation.h>

#include <log/equalizer.h>

namespace yxiva { namespace equalizer {

#define TSKV_LOG(severity) YLOG((*logger_), severity)

namespace tskv = yplatform::log::typed;

class log_impl
    : public yplatform::module
    , public equalizer_log
{
private:
    boost::optional<yplatform::log::tskv_logger> logger_;

public:
    void init(const yplatform::ptree& /*xml*/)
    {
        logger_ = yplatform::log::tskv_logger(YGLOBAL_LOG_SERVICE, "tskv");
        logger().set_log_prefix("equalizer");
    }

    void fini()
    {
    }

    void operation_sent(const string& db, const operation_ptr& op) override
    {
        if (op->action_type == action_t::NEW_MAIL) log_insert_operation(db, op, "sent");
    }

    void operation_ignored(const string& db, const operation_ptr& op, const string& reason) override
    {
        YLOG_CTX_LOCAL(op->ctx, info) << "ignore operation:"
                                         " uid=\""
                                      << op->uid() << "\" reason=\"" << reason << "\"";
        if (op->action_type == action_t::NEW_MAIL)
            log_insert_operation(db, op, "ignored_" + reason);
    }

    void operation_dropped(const string& db, const operation_ptr& op, const string& reason) override
    {
        YLOG_CTX_LOCAL(op->ctx, info) << "drop operation:"
                                         " uid=\""
                                      << op->uid() << "\" reason=\"" << reason << "\"";
        if (op->action_type == action_t::NEW_MAIL)
            log_insert_operation(db, op, "dropped_" + reason);
    }

private:
    void log_insert_operation(const string& db, const operation_ptr& op, const string& status)
    {
        TSKV_LOG(info) << tskv::make_attr("db", db) << tskv::make_attr("uid", op->uid())
                       << tskv::make_attr("mid", json_get<string>(op->parts.front(), "mid", ""))
                       << tskv::make_attr("status", status) << tskv::make_attr("event", "insert")
                       << tskv::make_attr("x-request-id", op->x_request_id);
    }
};

}}