#pragma once

#include <string>

#include <ymod_lease/node.h>

#include "syncer_settings.h"
#include "position_holder.h"
#include "no_sync.h"
#include "sync_file.h"
#include "sync_lease.h"
#include "sync_file_lease.h"

namespace yxiva { namespace equalizer {

template <typename PositionType>
typename position_holder<PositionType>::sync_strategy_ptr create_syncer(
    const syncer_settings<PositionType>& settings,
    boost::shared_ptr<ylease::node> lease_node)
{
    PositionType default_value = std::numeric_limits<PositionType>::min();
    switch (settings.dest)
    {
    case sync_dest::FILE:
        return std::make_shared<sync_file<PositionType>>(settings.path, default_value);
    case sync_dest::DISTR_LOCK:
        return std::make_shared<sync_lease<PositionType>>(lease_node, default_value);
    case sync_dest::DISTR_FILE_LOCK:
        return std::make_shared<sync_file_lease<PositionType>>(
            lease_node, settings.path, default_value);
    case sync_dest::NONE:
    default:
        return std::make_shared<no_sync<PositionType>>(default_value);
    }
}

}}