#pragma once

#include <fstream>

#include <boost/bind.hpp>
#include <boost/enable_shared_from_this.hpp>

#include "position_holder.h"

namespace yxiva { namespace equalizer {

template <typename PositionType = unsigned long>
class no_sync : public position_holder<PositionType>::isync_strategy
{
public:
    no_sync(const PositionType& def) : default_(def)
    {
    }

    PositionType restore(const string& /*resource_name*/)
    {
        return default_;
    }

    void sync(const string& /*resource_name*/, const PositionType& /*value*/)
    {
    }

private:
    PositionType default_;
};

}}