#pragma once

#include <fstream>

#include <boost/bind.hpp>
#include <boost/enable_shared_from_this.hpp>

#include "sync_file.h"
#include "sync_lease.h"

namespace yxiva { namespace equalizer {

template <typename PositionType = unsigned long>
class sync_file_lease
    : public sync_lease<PositionType>
    , public sync_file<PositionType>
{
    typedef sync_lease<PositionType> lease_base;
    typedef sync_file<PositionType> file_base;

public:
    sync_file_lease(
        boost::shared_ptr<ylease::node> lease_node,
        const string& basepath,
        const PositionType& def)
        : lease_base(lease_node, def), file_base(basepath, def), default_(def)
    {
    }

    PositionType restore(const string& resource_name)
    {
        auto restored = file_base::restore(resource_name);
        if (restored != default_)
        {
            lease_base::sync(resource_name, restored);
        }
        return restored;
    }

    void sync(const string& resource_name, const PositionType& value)
    {
        lease_base::sync(resource_name, value);
        file_base::sync(resource_name, value);
    }

private:
    const PositionType default_;
};

}}