#pragma once

#include <boost/bind.hpp>
#include <boost/enable_shared_from_this.hpp>

#include <ymod_lease/node.h>

#include "position_holder.h"

namespace yxiva { namespace equalizer {

template <typename PositionType = unsigned long>
class sync_lease : virtual public position_holder<PositionType>::isync_strategy
{
public:
    sync_lease(boost::shared_ptr<ylease::node> lease_node, const PositionType& def)
        : lease_node_(lease_node), default_(def)
    {
        assert(lease_node_);
    }

    PositionType restore(const string& /*resource_name*/)
    {
        return default_;
    }

    void sync(const string& resource_name, const PositionType& position)
    {
        update_resource_value(resource_name, position);
    }

protected:
    void update_resource_value(const string& resource_name, const PositionType& position)
    {
        try
        {
            string value = boost::lexical_cast<string>(position);
            lease_node_->update_acquire_value(resource_name, value);
        }
        catch (const std::exception& ex)
        {
            YLOG_G(error) << "error while updating position: exception=\"" << ex.what() << "\"";
        }
        catch (...)
        {
            YLOG_G(error) << "error while updating position: exception=\"unknown\"";
        }
    }

private:
    boost::shared_ptr<ylease::node> lease_node_;
    const PositionType default_;
};

}}