#pragma once

namespace yxiva { namespace equalizer {

enum sync_dest
{
    NONE,
    FILE,
    DISTR_LOCK,
    DISTR_FILE_LOCK
};

template <typename PositionType>
struct syncer_settings
{
    sync_dest dest;
    string path;
    PositionType default_value;

    bool operator==(const syncer_settings& other)
    {
        return dest == other.dest and path == other.path and default_value == other.default_value;
    }

    bool operator!=(const syncer_settings& other)
    {
        return not(*this == other);
    }
};

}}