#pragma once

#include <equalizer/operation.h>
#include "position/position_holder.h"
#include <processor/pipeline_types.h>
#include <equalizer/module_stats.h>

namespace yxiva { namespace equalizer {

using namespace pipeline;

class select_position_updater : public CommitListener<pipeline::StreamStrand<operation_ptr>>
{
    typedef CommitListener<pipeline::StreamStrand<operation_ptr>> base_t;
    typedef base_t::collection_ptr collection_ptr;

public:
    select_position_updater(
        std::shared_ptr<position_holder<std::size_t>> holder,
        const string& db_name,
        module_stats_ptr stats)
        : holder_(holder), db_name_(db_name), stats_(stats)
    {
    }

protected:
    void on_commit(collection_ptr committed_range)
    {
        auto operation = committed_range->back();
        unsigned long new_position = committed_range->back()->operation_id;
        holder_->position(db_name_, new_position);
        if (stats_) stats_->processed(db_name_, operation->ts);
    }

private:
    std::shared_ptr<position_holder<std::size_t>> holder_;
    const string db_name_;
    module_stats_ptr stats_;
};

}}
