#pragma once

#include <equalizer/operation.h>
#include <processor/pipeline_types.h>

namespace yxiva { namespace equalizer {

using namespace pipeline;

class fill_defaults
    : public Processor<pipeline::StreamStrand<operation_ptr>>
    , public yplatform::log::contains_logger
{
    typedef Processor<pipeline::StreamStrand<operation_ptr>> base_t;
    typedef base_t::stream_ptr stream_ptr;

public:
    fill_defaults(
        boost::asio::io_service& io,
        const StreamSettings& stream_st,
        string db_name,
        const yplatform::log::source& logger = yplatform::log::source())
        : base_t(io, stream_st), yplatform::log::contains_logger(logger), db_name_(db_name)
    {
        input()->label("fill_defaults");
    }

    string name() const
    {
        return "fill_defaults";
    }

protected:
    void on_data(stream_ptr stream, std::size_t begin_id, std::size_t end_id) noexcept
    {
        for (std::size_t id = begin_id; id < end_id; id++)
        {
            auto op = stream->at(id);
            op->stream_id = id;
            if (op->action_type == action_t::TRACE_PIPELINE) continue;
            YLOG_CTX_LOCAL(op->ctx, info) << "operation:"
                                             " db=\""
                                          << db_name_
                                          << "\""
                                             " stream_id="
                                          << op->stream_id
                                          << ""
                                             " operation_id="
                                          << op->operation_id
                                          << ""
                                             " uid=\""
                                          << op->uid()
                                          << "\""
                                             " suid=\""
                                          << op->suid()
                                          << "\""
                                             " lcn=\""
                                          << op->lcn
                                          << "\""
                                             " action=\""
                                          << op->action_type
                                          << "\""
                                             " size="
                                          << op->total_count
                                          << ""
                                             " x_request_id=\""
                                          << op->x_request_id << "\"";
        }
        stream->commit_until(end_id - 1);
    }

private:
    const string db_name_;
};

}}
