#pragma once

#include <equalizer/context.h>
#include <equalizer/operation.h>
#include <processor/pipeline_types.h>

namespace yxiva { namespace equalizer {

using namespace pipeline;

template <class Operation>
class simple_printer : public pipeline::Processor<pipeline::StreamStrand<Operation>>
{
    typedef pipeline::Processor<pipeline::StreamStrand<Operation>> base_t;
    typedef typename base_t::stream_ptr stream_ptr;

public:
    simple_printer(boost::asio::io_service& io, const StreamSettings& stream_st)
        : base_t(io, stream_st)
    {
    }

    string name() const
    {
        return "printer";
    }

protected:
    void on_data(stream_ptr stream, std::size_t begin_id, std::size_t end_id) noexcept
    {
        for (std::size_t it = begin_id; it < end_id; it++)
        {
            auto& item = *stream->at(it);
            YLOG_G(info) << "[simple_printer] " << to_string(item);
        }
        stream->commit_until(end_id - 1);
    }

    string to_string(const operation& op)
    {
        std::stringstream ss;
        ss << "stream_id=\"" << op.stream_id << "\" operation_id=\"" << op.operation_id
           << "\" uid=\"" << op.uid() << "\" suid=\"" << op.suid() << "\" lcn=\"" << op.lcn
           << "\" action=\"" << op.action_type << "\" args=\"" << op.args << "\" with parts: [";
        for (auto& part : op.parts)
        {
            ss << part << ", ";
        }
        ss << "]";
        return ss.str();
    }
};

}}
