#pragma once

#include <ymod_httpclient/call.h>
#include <yplatform/ptree.h>
#include <string>

namespace yxiva { namespace equalizer {

inline void load_timeouts_from_ptree(
    const yplatform::ptree& conf,
    boost::optional<ymod_http_client::timeouts>& timeouts_opt)
{
    if (auto net_settings_opt = conf.get_child_optional("net_settings"))
    {
        auto net_settings = net_settings_opt.get();
        using yplatform::time_traits::milliseconds;
        using yplatform::time_traits::duration;
        auto max_millis_count = milliseconds::max().count();
        auto max_millis = milliseconds::max();
        ymod_http_client::timeouts timeouts;
        timeouts.connect = milliseconds(net_settings.get("connect_timeout", max_millis_count));
        timeouts.total = milliseconds(net_settings.get("request_timeout", max_millis_count));
        bool is_filled =
            std::tie(timeouts.connect, timeouts.total) != std::make_tuple(max_millis, max_millis);
        if (is_filled) timeouts_opt = timeouts;
    }
}

}}
