#pragma once

#include "equalizer/action.h"
#include <yxiva/core/types.h>
#include <yplatform/ptree.h>

namespace yxiva { namespace equalizer {

inline void ptree_convert(const yplatform::ptree& conf, action_t& out)
{
    auto value = conf.get_value<string>();
    for (int i = 0; i < action_t::COUNT; i++)
    {
        if (action_to_str[i] == value)
        {
            out = static_cast<action_t>(i);
            return;
        }
    }
    throw std::runtime_error("no action found for string \"" + value + "\"");
}

using yplatform::read_ptree;

}}
