#pragma once

#include <processor/pipeline_types.h>
#include <yplatform/ptree.h>

namespace yxiva { namespace equalizer {

inline void stream_settings_from_ptree(
    const yplatform::ptree& conf,
    const string& path,
    StreamSettings& stream,
    const StreamSettings& defaults = StreamSettings(100))
{
    const string prefix = path.empty() ? "stream." : path + ".stream.";
    stream.capacity = conf.get(prefix + "capacity", defaults.capacity);
    stream.window = conf.get(prefix + "window", defaults.window);
    stream.grouped_flush_size =
        conf.get(prefix + "grouped_flush_size", defaults.grouped_flush_size);
    YLOG_G(info) << "stream config: name=" << path << " capacity=" << stream.capacity
                 << " window=" << stream.window
                 << " grouped_flush_size=" << stream.grouped_flush_size;
}

}}
