#include "impl.h"

#include <yplatform/find.h>
#include <ymod_webserver/server.h>
#include <yxiva/core/methods/dispatcher.h>
#include <yxiva/core/methods/key_extractor.h>
#include <yxiva/core/authorizer.h>
#include <yxiva/core/auth/caching_authorizer.h>

#include "methods/notify.h"
#include "methods/ping.h"
#include "methods/read_state.h"
#include "methods/run_generator.h"
#include "methods/acquired_shards_info.h"
#include "methods/drop_shard.h"

namespace yxiva { namespace equalizer { namespace web {

void impl::init(const yplatform::ptree& xml)
{
    settings_ = make_shared<settings>();
    settings_->endpoint = xml.get("endpoint", "");
    settings_->webserver_module_name = xml.get("http_server_module", "web_server");

    string processor_name = xml.get("processor_module", "equalizer");
    settings_->processor_module = yplatform::find<equalizer::processor>(processor_name);

    settings_->authorizer.reset(new caching_authorizer(boost::make_shared<authorizer_blackbox>()));

    web_handler::dispatcher_t::methods_map_t all_methods;
    all_methods["notify"] = methods::notify;
    all_methods["ping"] = methods::ping;
    all_methods["start_generator"] = methods::start_generator;
    all_methods["stop_generator"] = methods::stop_generator;
    all_methods["state"] = methods::read_state;
    all_methods["acquired_shards_info"] = methods::get_acquired_shards_info;
    all_methods["drop_shard"] = methods::drop_shard;
    all_methods["drop_shard_all"] = methods::drop_all_shards;

    web_handler::dispatcher_t dispatcher(
        boost::bind(yxiva::methods::key_extract_path_root, _1), all_methods);
    handler_ = make_shared<web_handler>(dispatcher, settings_);
}

void impl::start()
{
    auto webserver_module =
        yplatform::find<ymod_webserver::server>(settings_->webserver_module_name);
    assert(webserver_module);

    webserver_module->subscribe(settings_->endpoint, handler_);
}

}}}

#include <yplatform/module_registration.h>
DEFINE_SERVICE_OBJECT(yxiva::equalizer::web::impl)
