#pragma once

#include <lock_manager/module.h>

#include <ymod_webserver/request.h>
#include <ymod_webserver/response.h>

#include "../settings.h"
#include <boost/property_tree/json_parser.hpp>

namespace yxiva { namespace equalizer { namespace web { namespace methods {

void get_acquired_shards_info(
    ymod_webserver::request_ptr /*req*/,
    ymod_webserver::response_ptr resp,
    settings_ptr /*settings*/)
{
    auto lock_manager = yplatform::find<lock_manager_module>("lock-manager");
    lock_manager->get_owned_locks([resp](const std::vector<std::string>& shards) {
        std::stringstream stream;
        yplatform::ptree ret;
        auto& shards_node = ret.put_child("acquired_shards", yplatform::ptree{});
        for (auto& shard : shards)
        {
            yplatform::ptree shard_node;
            shard_node.put_value(shard);
            shards_node.push_back(std::make_pair("", shard_node));
        }
        boost::property_tree::write_json(stream, ret);
        resp->result(ymod_webserver::codes::ok, stream.str());
    });
}

}}}}
