#include "drop_shard.h"

#include <ymod_webserver/codes.h>

namespace yxiva { namespace equalizer { namespace web { namespace methods {

void drop_shard(
    ymod_webserver::request_ptr req,
    ymod_webserver::response_ptr resp,
    settings_ptr settings)
{
    string shard_id = req->url.param_value("id", "");
    string shard_name = req->url.param_value("name", "");
    if (shard_id.size() or shard_name.size())
    {
        settings->processor_module->drop_shard(shard_id, shard_name);
        resp->result(ymod_webserver::codes::ok, "");
    }
    else
    {
        resp->result(ymod_webserver::codes::bad_request, "Empty shard name or id");
    }
}

void drop_all_shards(
    ymod_webserver::request_ptr /*req*/,
    ymod_webserver::response_ptr resp,
    settings_ptr settings)
{
    settings->processor_module->drop_shard("");
    resp->result(ymod_webserver::codes::ok, "");
}

}}}}
