#include "notify.h"

#include <sstream>
#include <boost/algorithm/string/trim.hpp>
#include <yxiva/core/json.h>

#include <ymod_webserver/codes.h>
#include <yxiva/core/authorizer.h>
#include <yxiva/core/auth/error.h>

#include <equalizer/operation.h>
#include "../decoder/decode_json.h"

namespace yxiva { namespace equalizer { namespace web { namespace methods {

void read_state(
    ymod_webserver::request_ptr /*req*/,
    ymod_webserver::response_ptr resp,
    settings_ptr settings)
{
    json_value value = settings->processor_module->full_state();
    resp->result(ymod_webserver::codes::ok, value.pretty_stringify());
}

}}}}
