#include "run_generator.h"

#include <sstream>
#include <boost/bind/protect.hpp>

#include <ymod_webserver/codes.h>
#include <yxiva/core/authorizer.h>
#include <yxiva/core/auth/error.h>

#include <equalizer/operation.h>
#include <web/decoder/decode_json.h>

namespace yxiva { namespace equalizer { namespace web { namespace methods {

void start_generator(
    ymod_webserver::request_ptr /*req*/,
    ymod_webserver::response_ptr resp,
    settings_ptr settings)
{
    settings->processor_module->start_generator();
    resp->result(ymod_webserver::codes::ok, "Generator started");
}

void stop_generator(
    ymod_webserver::request_ptr /*req*/,
    ymod_webserver::response_ptr resp,
    settings_ptr settings)
{
    settings->processor_module->stop_generator();
    resp->result(ymod_webserver::codes::ok, "Generator stopped");
}

}}}}
