#pragma once

#include <ymod_webserver/handler.h>
#include <yxiva/core/methods/dispatcher.h>

#include "settings.h"

namespace yxiva { namespace equalizer { namespace web {

using ymod_webserver::request_ptr;
using ymod_webserver::response_ptr;

class web_handler
    : public ymod_webserver::handler
    , public enable_shared_from_this<web_handler>
{
public:
    typedef methods::
        dispatcher<ymod_webserver::request_ptr, ymod_webserver::response_ptr, settings_ptr>
            dispatcher_t;

public:
    web_handler(const dispatcher_t& dispatcher, settings_ptr settings);

    void execute(request_ptr req, response_ptr stream);

private:
    dispatcher_t dispatch_;
    settings_ptr settings_;
};

typedef shared_ptr<web_handler> web_handler_ptr;

}}}
