#!/bin/bash

# Try to remove logs uploaded today.
timetail -r '^(\S+ \S+)' -n $[24*60*60] /var/log/logbackup.log | head -n -1 | grep -F '<f+++++++++' | awk '{print $NF}' | while read -r logfile ; do
    if [[ -f "/var/log/yamail-logs/$logfile" ]]; then
        rm "/var/log/yamail-logs/$logfile"
    fi
done

# If disk usage is more than 80%, remove some of the oldest logs.
USAGE_PERC=$(df --output=pcent /var/log/yamail-logs/ | tail -n 1 | grep -o '[0-9]*')
if [ $USAGE_PERC -gt 80 ]; then
    ls -1 /var/log/yamail-logs/* | awk -F '.' '{print $(NF-1), $0}' | sort -g | cut -d ' ' -f 2 | head -n 12 | xargs rm
fi
