#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eu

# TODO purge copy-paste
function ephemeral_log {
    rm -rf "/var/log/$1"
    mkdir -p "/ephemeral/logs/$1"
    ln -s "/ephemeral/logs/$1" /var/log/
}

function http_call {
    >/tmp/curl
    code=$(curl --max-time 120 --write-out %{http_code} --silent --output /tmp/curl $@)
    if [[ $code =~ 2[0-9][0-9] ]]; then
        cat /tmp/curl
        return 0;
    fi
    return 1;
}

http_call localhost:1/metadata?state=current\&format=text > /tmp/current_topology
http_call localhost:1/metadata?state=target\&format=text > /tmp/target_topology
cat /tmp/current_topology /tmp/target_topology | sort -u -k3,3 | awk '{print $3}' > /tmp/all_hosts

# WARNING changing port numbers may corrupt cluster metadata on deploy
netch_port=8000
http_port=8080

# cut qloud component from qloud instance id to eval paxos node id
topology_json=$(cat /tmp/target_topology \
    | awk '{ s = s "\"" $1 "," $3 ":'"${netch_port}"'\","} END { print "[" substr(s, 1, length(s)-1) "]"; }' \
    | sed "s/${QLOUD_COMPONENT}-//g")

# dump for debug purposes
echo $topology_json > /tmp/update_topology.json

for h in $(cat /tmp/all_hosts); do
    http_call "${h}:${http_port}/update_topology" --data-urlencode 'peers='"${topology_json}" >> "/tmp/${h}.update_topology.log" || true
done

sleep 5

# ready to start, TODO check new topology is delivered
